const mix = require('laravel-mix');

mix.js('resources/js/app.js', 'public/js')
    .babelConfig({
        presets: ['@babel/preset-env'],
    })
    .postCss('resources/css/app.css', 'public/css', [
        require('postcss-import'),
        require('tailwindcss'),
        require('autoprefixer'),
    ])
    .autoload({
        jquery: ['$', 'jQuery'], // Hace que jQuery esté disponible globalmente
    });

// Copiar archivos de DataTables y Bootstrap
mix.copy('node_modules/datatables.net/js/dataTables.min.js', 'public/js')
   .copy('node_modules/datatables.net-bs4/js/dataTables.bootstrap4.min.js', 'public/js')
   .copy('node_modules/datatables.net-bs4/css/dataTables.bootstrap4.min.css', 'public/css');

// Versionado para producción
if (mix.inProduction()) {
    mix.version();
}
