<?php $__env->startSection('title', 'Listado de Distribuidores'); ?>

<?php $__env->startSection('content_header'); ?>

    <?php if(!empty($cod_patro) && $cod_patro!=NULL): ?>
      <?php if($estado): ?>
      <a class="btn btn-primary float-right mb-3 mb-md-0" href="<?php echo e(route('admin.distribuidores.create')); ?>">
        <i class="fas fa-plus-circle"></i> Registrar Distribuidor
      </a>
      <?php else: ?>
          
      <?php endif; ?>
    <?php else: ?>  
    <a class="btn btn-primary float-right mb-3 mb-md-0" href="<?php echo e(route('admin.distribuidores.create')); ?>">
        <i class="fas fa-plus-circle"></i> Registrar Distribuidor
    </a>
    <?php endif; ?>

    <h1 class="text-bold">Lista de Distribuidores</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            
            <form action="<?php echo e(route('admin.distribuidores.index')); ?>" method="GET" class="d-flex"
                style="gap: 10px; width: 50%;">
                <input name="search" class="form-control" type="text" placeholder="Buscar por Código o Nombre"
                    value="<?php echo e(request('search')); ?>">
                <button class="btn btn-primary" type="submit">Buscar</button>
            </form>

            
            <?php echo $__env->make('admin.paginador.index', ['data' => $data], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>

        
        <?php if($data['distribuidores']->count()): ?>
            <div class="card-body">
                <form id="estadoForm" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="border text-center">
                                <tr>
                                    <th><input type="checkbox" id="selectAll"></th>
                                    <th>ID</th>
                                    <th>Código</th>
                                    <th>Nombre</th>
                                    <th>Dirección</th>
                                    <th>Teléfono</th>
                                    <th>Email</th>
                                    <th>Estado Web</th>
                                    
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $data['distribuidores']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $distribuidor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="text-center">
                                            <input type="checkbox" class="distribuidorCheckbox"
                                                value="<?php echo e($distribuidor->cdg_dist); ?>">
                                        </td>
                                        <td><?php echo e($data['tamanio'] * ($data['pagina'] - 1) + $loop->iteration); ?></td>
                                        <td><?php echo e($distribuidor->cdg_dist); ?></td>
                                        <td><?php echo e($distribuidor->NOM_DIS); ?></td>
                                        <td><?php echo e($distribuidor->dir_dist); ?></td>
                                        <td><?php echo e($distribuidor->tel_dist); ?></td>
                                        <td><?php echo e($distribuidor->ema_dist); ?></td>
                                        <td class="text-center">
                                            <?php if($distribuidor->estado_web == '1'): ?>
                                                <span class="badge bg-success">Activo</span>
                                            <?php else: ?>
                                                <span class="badge bg-danger">Inactivo</span>
                                            <?php endif; ?>
                                        </td>
                                        
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <button type="button" class="btn btn-primary mt-3" id="activarSeleccionados">Activar Seleccionados</button>
                    <button type="button" class="btn btn-danger mt-3" id="desactivarSeleccionados">Desactivar
                        Seleccionados</button>
                </form>
            </div>
        <?php else: ?>
            <div class="card-body">
                <strong>Sin registros</strong>
            </div>
        <?php endif; ?>
    </div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<?php echo $__env->make('admin.distribuidores.activacion-cuenta-web', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\Sistema-web\resources\views/admin/distribuidores/index.blade.php ENDPATH**/ ?>