<div class="container">
    <h3>Cliente</h3>
    <form wire:submit.prevent="save">
        <div class="row">
            <!-- Código -->
            <div class="col-md-6">
                <label for="codigo">Código</label>
                <input type="text" id="codigo" class="form-control" wire:model="cliente.codigo" placeholder="Ingrese el código" readonly>
            </div>

            <div class="col-md-6 d-flex align-items-center">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="activo" wire:model="cliente.activo">
                    <label class="form-check-label" for="activo">Activo</label>
                </div>
                <div class="form-check ms-3">
                    <input class="form-check-input" type="checkbox" id="agente_retendedor" wire:model="cliente.agente_retendedor">
                    <label class="form-check-label" for="agente_retendedor">Agente Retenedor</label>
                </div>
            </div>
        </div>

        <div class="row mt-3">
            <!-- Tipo de documento -->
            <div class="col-md-6">
                <label for="tipo_documento">Tipo de Documento</label>
                <select id="tipo_documento" class="form-control" wire:model="cliente.tipo_documento">
                    <option value="">--Seleccione--</option>
                    <option value="DNI">DNI</option>
                    <option value="RUC">RUC</option>
                </select>
            </div>

            <!-- Documento -->
            <div class="col-md-6">
                <label for="documento">Documento</label>
                <div class="input-group">
                    <input type="text" id="documento" class="form-control" wire:model="cliente.documento">
                    <button type="button" class="btn btn-primary">Sunat</button>
                </div>
            </div>
        </div>

        <div class="row mt-3">
            <!-- Nombres o Razón -->
            <div class="col-md-12">
                <label for="nombres_razon">Nombres o Razón</label>
                <input type="text" id="nombres_razon" class="form-control" wire:model="cliente.nombres_razon">
            </div>
        </div>

        <div class="row mt-3">
            <!-- Ubicación -->
            <div class="col-md-3">
                <label for="pais">País</label>
                <input id="pais" class="form-control" list="listaPaises" wire:model="cliente.pais" placeholder="Seleccione o escriba un país">
                <datalist id="listaPaises">
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $paises; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cdg_pais => $des_pais): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($des_pais); ?>"><?php echo e($des_pais); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </datalist>
            </div>
            <div class="col-md-3">
                <label for="departamento">Departamento</label>
                <input id="departamento" class="form-control" list="listaDepartamentos" wire:model="cliente.departamento" placeholder="Seleccione o escriba un departamento">
                <datalist id="listaDepartamentos">
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $departamentos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cdg_dpto => $des_dpto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($des_dpto); ?>"><?php echo e($des_dpto); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </datalist>
            </div>
            <div class="col-md-3">
                <label for="provincia">Provincia</label>
                <input id="provincia" class="form-control" list="listaProvincias" wire:model="cliente.provincia" placeholder="Seleccione o escriba una provincia">
                <datalist id="listaProvincias">
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $provincias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cdg_prov => $des_prov): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($des_prov); ?>"><?php echo e($des_prov); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </datalist>
            </div>
            <div class="col-md-3">
                <label for="distrito">Distrito</label>
                <input id="distrito" class="form-control" list="listaDistritos" wire:model="cliente.distrito" placeholder="Seleccione o escriba un distrito">
                <datalist id="listaDistritos">
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $distritos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cdg_dsto => $des_dsto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($des_dsto); ?>"><?php echo e($des_dsto); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </datalist>
            </div>
        </div>

        <div class="row mt-3">
            <!-- Dirección -->
            <div class="col-md-12">
                <label for="direccion">Dirección</label>
                <input type="text" id="direccion" class="form-control" wire:model="cliente.direccion">
            </div>
        </div>

        <div class="row mt-3">
            <!-- Tipo Cliente -->
            <div class="col-md-6">
                <label>Tipo Cliente</label>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="tipo_cliente" id="persona_juridica" value="Persona Juridica" wire:model="cliente.tipo_cliente">
                    <label class="form-check-label" for="persona_juridica">Persona Jurídica</label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="tipo_cliente" id="persona_natural" value="Persona Natural" wire:model="cliente.tipo_cliente">
                    <label class="form-check-label" for="persona_natural">Persona Natural</label>
                </div>
            </div>

            <!-- Contacto -->
            <div class="col-md-3">
                <label for="contacto">Contacto</label>
                <input type="text" id="contacto" class="form-control" wire:model="cliente.contacto">
            </div>

            <!-- Teléfono -->
            <div class="col-md-3">
                <label for="telefono">Teléfono</label>
                <input type="text" id="telefono" class="form-control" wire:model="cliente.telefono">
            </div>
        </div>

        <div class="row mt-4">
            <!-- Botones -->
            <div class="col-md-12 text-end">
                <button type="button" class="btn btn-secondary" wire:click="reset">Cerrar</button>
                <button type="submit" class="btn btn-primary">Guardar</button>
            </div>
        </div>
    </form>
</div>
<?php /**PATH C:\laragon\www\Sistema-web\resources\views/livewire/clientes/formulario.blade.php ENDPATH**/ ?>