<div class="card">
    <div class="card-header">
        <div class="d-flex  " style="gap: 15px; flex-wrap: wrap;">
            <!-- Filtro por Almacén -->
            <div>
                <label for="almacenFilter" class="form-label">Filtrar por Almacén:</label>

                <select class="form-control mr-1" wire:model="selectedAlmacen" id="almacenFilter" class="form-select">
                    <option value="">Todos los Almacenes</option>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $almacenes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $almacen): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($almacen->Num_item); ?>"><?php echo e($almacen->Des_item); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </select>
                <button wire:click="buscarPorAlmacen" class="btn btn-secondary mt-2">
                    Aplicar Filtro
                </button>
            </div>

            <!-- Campo de Búsqueda -->
            <div>
                <label for="searchInput" class="form-label">Buscar Producto:</label>
                <div class="input-group" style="min-width: 300px;">
                    <input wire:model.defer="search" id="searchInput" type="text" class="form-control" placeholder="Buscar por Producto o Código...">
                    <button wire:click="buscar" class="btn btn-primary">
                        Buscar
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!--[if BLOCK]><![endif]--><?php if($productos->count()): ?>
        <div class="card-body" style="overflow: hidden">
            <div>
                <?php echo e($productos->links()); ?>

            </div>
            <div class="table-responsive">
                <table class="table table-bordered table-hover">
                    <thead class="border text-center">
                        <tr>
                            <th>Item</th>
                            <th>Código Producto</th>
                            <th>Descripción</th>
                            <th>Familia</th>
                            <th>Línea</th>
                            <th>Tipo</th>
                            <th>Unidad de Medida</th>
                            <th>Valor Sol</th>
                            <th>Valor Dólar</th>
                            <th>Stock Actual</th>
                            <th>Estado</th>
                            <th>Almacén</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $productos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($productos->perPage() * ($productos->currentPage() - 1) + $loop->iteration); ?></td>
                                <td><?php echo e($producto->Cdg_prod); ?></td>
                                <td><?php echo e($producto->Des_prod); ?></td>
                                <td><?php echo e($producto->Familia); ?></td>
                                <td><?php echo e($producto->Linea); ?></td>
                                <td><?php echo e($producto->Tipo); ?></td>
                                <td><?php echo e($producto->UNM); ?></td>
                                <td><?php echo e($producto->Val_sol); ?></td>
                                <td><?php echo e($producto->Val_dol); ?></td>
                                <td><?php echo e($producto->Stk_act); ?></td>
                                <td><?php echo e($producto->swt_est == 1 ? 'Activo' : 'Inactivo'); ?></td>
                                <td><?php echo e($producto->Des_item); ?></td>
                                <td width="200px">
                                    <div class="d-flex" style="gap: 10px">
                                        <button class="btn btn-sm btn-info">
                                            <i class="fas fa-pen"></i>
                                        </button>
                                        <button class="btn btn-sm btn-success">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger">
                                            <i class="fas fa-minus-circle"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </tbody>
                </table>
            </div>
        </div>
    <?php else: ?>
        <div class="card-body">
            <strong>Sin registros</strong>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div>
<?php /**PATH C:\laragon\www\Sistema-web\resources\views/livewire/productos/lista.blade.php ENDPATH**/ ?>