<?php $__env->startSection('title', 'Crear Rol'); ?>

<?php $__env->startSection('content_header'); ?>
    <a href="<?php echo e(route('admin.roles.index')); ?>" class="float-right mt-2">
        <i class="fas fa-chevron-circle-left"></i> Ver lista de roles
    </a>
    <h1 class="text-bold">Crear Rol</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <form action="<?php echo e(route('admin.roles.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>

            <!-- Campo para el nombre del rol -->
            <div class="card-body">
                <div class="form-group">
                    <label for="name" class="font-weight-bold">Nombre del rol</label>
                    <input type="text" name="name" id="name" class="form-control"
                        placeholder="Ingrese el nombre del rol" value="<?php echo e(old('name')); ?>">
                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <small class="text-danger"><?php echo e($message); ?></small>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Lista de permisos estructurados -->
                <h5 class="font-weight-bold">Lista de Permisos</h5>
                <ul class="list-group">
                    <?php $__currentLoopData = $structuredPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="list-group-item">
                            <i class="fas fa-folder-open"></i> <?php echo e($category['text']); ?>

                            <?php if(!empty($category['submenu'])): ?>
                                <ul class="list-group mt-2">
                                    <?php $__currentLoopData = $category['submenu']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="list-group-item">
                                            <label>
                                                <input type="checkbox" name="permissions[]"
                                                    value="<?php echo e($permission['route']); ?>" class="mr-2"
                                                    <?php echo e(in_array($permission['route'], $selectedPermissions) ? 'checked' : ''); ?>>
                                                <i class="<?php echo e($permission['icon']); ?>"></i> <?php echo e($permission['text']); ?>

                                            </label>
                                            <?php if(!empty($permission['submenu'])): ?>
                                                <ul class="mt-2 submenu-list">
                                                    <?php $__currentLoopData = $permission['submenu']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subpermission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li class="list-group-item">
                                                            <label>
                                                                <input type="checkbox" name="permissions[]"
                                                                    value="<?php echo e($subpermission['route']); ?>" class="mr-2"
                                                                    <?php echo e(in_array($subpermission['route'], $selectedPermissions) ? 'checked' : ''); ?>>
                                                                <i class="<?php echo e($subpermission['icon']); ?>"></i>
                                                                <?php echo e($subpermission['text']); ?>

                                                            </label>
                                                        </li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            <?php endif; ?>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            <?php endif; ?>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>

                <div class="mt-4 d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary">Guardar</button>
                    <a href="<?php echo e(url()->previous()); ?>" class="btn btn-danger ml-2">Cancelar</a>
                </div>
        </form>
    </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            document.querySelectorAll('.list-group-item > .fas').forEach(icon => {
                icon.addEventListener('click', function() {
                    const submenu = this.closest('li').querySelector('.submenu-list');
                    if (submenu) {
                        submenu.style.display = submenu.style.display === 'none' ? 'block' : 'none';
                        this.classList.toggle('fa-folder-open');
                        this.classList.toggle('fa-folder');
                    }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\Sistema-web\resources\views/admin/roles/create.blade.php ENDPATH**/ ?>