<?php $__env->startSection('title', 'Ver Rol'); ?>

<?php $__env->startSection('content_header'); ?>
    <a href="<?php echo e(route('admin.roles.index')); ?>" class="float-right mt-2">
        <i class="fas fa-chevron-circle-left"></i> Ver lista de roles
    </a>
    <h1 class="text-bold">Ver Rol</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header d-flex flex-wrap justify-content-between align-items-center">
            <h5 class="flex-grow-1">Rol: <span class="badge badge-warning"><?php echo e($role->name); ?></span></h5>
            <a href="<?php echo e(route('admin.roles.edit', $role)); ?>" class="btn btn-sm btn-success text-nowrap">
                <i class="fas fa-pen"></i> Editar
            </a>
        </div>
        <div class="card-body">
            <!-- Campo para el nombre del rol -->
            <div class="form-group">
                <label for="name" class="font-weight-bold">Nombre del rol</label>
                <input type="text" id="name" class="form-control-plaintext" value="<?php echo e($role->name); ?>" readonly>
            </div>

            <!-- Lista de permisos estructurados -->
            <h5 class="font-weight-bold">Lista de Permisos</h5>
            <ul class="list-group">
                <?php $__currentLoopData = $structuredPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="list-group-item">
                        <i class="fas fa-folder-open"></i> <?php echo e($category['text']); ?>

                        <?php if(!empty($category['submenu'])): ?>
                            <ul class="list-group mt-2">
                                <?php $__currentLoopData = $category['submenu']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="list-group-item">
                                        <?php echo e($permission['text']); ?>

                                        <?php if(!empty($permission['submenu'])): ?>
                                            <ul class="mt-2 submenu-list">
                                                <?php $__currentLoopData = $permission['submenu']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subpermission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li class="list-group-item">
                                                        <?php echo e($subpermission['text']); ?>

                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        <?php endif; ?>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        <?php endif; ?>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <?php if(session('success') == 'update'): ?>
        <script>
            Swal.fire({
                icon: 'success',
                title: 'El rol se editó con éxito',
            })
        </script>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\Sistema-web\resources\views/admin/roles/show.blade.php ENDPATH**/ ?>