<?php $__env->startSection('title', 'Listado de Clientes'); ?>

<?php $__env->startSection('content_header'); ?>

<h1 class="text-bold">Lista de Clientes</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        
        <form action="<?php echo e(route('admin.clientes.index')); ?>" method="GET" class="d-flex" style="gap: 10px; width: 50%;">
            <input name="search" class="form-control" type="text" placeholder="Buscar por Código de pedido o RUC" value="<?php echo e(request('search')); ?>">
            <button class="btn btn-primary" type="submit">Buscar</button>
        </form>

        
        <?php echo $__env->make('admin.paginador.index', ['data' => $data], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>

    
    <?php if($data['clientes']->count()): ?>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover">
                    <thead class="border text-center">
                        <tr>
                            <th>ID</th>
                            
                            <th>RUC Cliente</th>
                            <th>Nombre Cliente</th>
                            <th>Dirección</th>
                            <th>Teléfono</th>
                            <th>Email</th>
                            <th>Estado</th>

                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $data['clientes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $cliente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($data['tamanio'] * ($data['pagina'] - 1) + $loop->iteration); ?></td>
                                <td><?php echo e($cliente->Ruc_cli); ?></td>
                                <td><?php echo e($cliente->Des_cli); ?></td>
                                <td><?php echo e($cliente->Dir_cli); ?></td>
                                <td><?php echo e($cliente->Tel_cli); ?></td>
                                <td><?php echo e($cliente->Ema_cli); ?></td>
                                <td><?php echo e($cliente->ESTADO); ?></td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php else: ?>
        <div class="card-body">
            <strong>Sin registros</strong>
        </div>
    <?php endif; ?>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\Sistema-web\resources\views/admin/clientes/index.blade.php ENDPATH**/ ?>