<?php $__env->startSection('title', 'Listado de Cotizaciones'); ?>

<?php $__env->startSection('content_header'); ?>
<a class="btn btn-primary float-right mb-3 mb-md-0" href="<?php echo e(route('admin.cotizaciones.create')); ?>">
    <i class="fas fa-plus-circle"></i> Registrar Cotizacion
</a>
    <h1 class="text-bold">Lista de Cotizaciones</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <!-- Livewire Component -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            
            <form action="<?php echo e(request()->url()); ?>" method="GET" class="d-flex" style="gap: 10px; width: 50%;">
                <input name="search" class="form-control" type="text" placeholder="Buscar por Número de Cotización, Codigo de Vendedor o Cliente..." value="<?php echo e(request('search')); ?>">
                <button class="btn btn-primary" type="submit">Buscar</button>
            </form>

            
            <?php echo $__env->make('admin.paginador.index', ['data' => $data], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>

        
        <?php if($data['items']->count()): ?>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="border text-center">
                            <tr>
                                <th>ID</th>
                                <th>Número</th>
                                <th>Vendedor</th>
                                <th>Moneda</th>
                                <th>Fecha Cotización</th>
                                <th>ESTADO</th>
                                <th>RUC Cliente</th>
                                <th>Cliente</th>
                                <th>Fecha Entrega</th>
                                <th>IMPORTE</th>
                                
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $data['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cotizacion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($data['tamanio'] * ($data['pagina'] - 1) + $loop->iteration); ?></td>
                                    <td><?php echo e($cotizacion->NUM_COT); ?></td>
                                    <td><?php echo e($cotizacion->DES_VEND); ?></td>
                                    <td><?php echo e($cotizacion->MONEDA); ?></td>
                                    <td><?php echo e($cotizacion->FEC_COT); ?></td>
                                    <td><?php echo e($cotizacion->ESTADO); ?></td>
                                    <td><?php echo e($cotizacion->RUC_CLI); ?></td>
                                    <td><?php echo e($cotizacion->DES_CLI); ?></td>
                                    <td><?php echo e($cotizacion->FEC_REF); ?></td>
                                    <td><?php echo e($cotizacion->IMP_TTOT); ?></td>
                                    
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php else: ?>
            <div class="card-body">
                <strong>No se encontraron registros.</strong>
            </div>
        <?php endif; ?>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\Sistema-web\resources\views/admin/cotizaciones/index.blade.php ENDPATH**/ ?>