<div class="modal fade" id="modalBuscarProducto" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Búsqueda de Productos</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Tabla de productos -->
                <table id="tablaProductosModal" class="table table-striped">
                    <thead>
                        <tr>
                            <th>Código</th>
                            <th>Descripción</th>
                            <th>Med.</th>
                            <th>Precio</th>
                            <th>Stock</th>
                            <th>Acción</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            $num=0;
                        ?>
                        <?php $__currentLoopData = $productos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        ++$num
                                    ?>
                            <tr>
                                <td><?php echo e($producto->Cdg_prod); ?></td>
                                <td><?php echo e($producto->Des_prod); ?></td>
                                <td><?php echo e($producto->UNM); ?></td>
                                <td><?php echo e($producto->Val_sol); ?></td>
                                <td><?php echo e($producto->Stk_act); ?></td>
                                
                                <td>
                                    <button class="btn btn-success btnSeleccionarProducto"
                                            data-codigo="<?php echo e($producto->Cdg_prod); ?>"
                                            data-descripcion="<?php echo e($producto->Des_prod); ?>"
                                            data-unidad="<?php echo e($producto->UNM); ?>"
                                            data-precio="<?php echo e($producto->Val_sol); ?>">
                                        <i class="fas fa-check"></i> Seleccionar
                                    </button>
                                </td>
                            </tr>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div> 
<link rel="stylesheet" href="
https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap4.min.css
">
<!-- DataTables JS -->
<script src="
https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js
"></script>
<script src="
https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap4.min.js
"></script>
<!-- Bootstrap -->
<script src="
https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js
"></script>
<link rel="stylesheet" href="
https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css
">


<script>
    $(document).ready(function() {
        // Inicializar DataTables
        $('#tablaClientes').DataTable({
            pageLength: 5, // Mostrar 5 registros por página
            language: {
                url: '
//cdn.datatables.net/plug-ins/2.1.8/i18n/es-ES.json
' // Español
            },
            columnDefs: [{
                    orderable: false,
                    targets: [4]
                } // Deshabilitar ordenamiento en la columna de "Acción"
            ]
        });

        // Manejar la selección de cliente
        $(document).on('click', '.btnSeleccionar', function() {
            var ruc = $(this).data('ruc');
            var nombre = $(this).data('nombre');
            var direccion = $(this).data('direccion');
            var correo = $(this).data('correo');

            // Llenar los campos en el formulario principal
            $('#ruc_dni').val(ruc);
            $('#nombre_cliente').val(nombre);
            $('#direccion').val(direccion);
            $('#correo').val(correo);

            // Cerrar el modal
            $('#modalBuscarCliente').modal('hide');
        });
    });
</script>


<script>
    $(document).ready(function() {
        let productCounter = 0; // Contador para generar índices únicos

        // Inicializar DataTable en el modal de productos
        $('#tablaProductosModal').DataTable({
            pageLength: 5,
            language: {
                url: '
//cdn.datatables.net/plug-ins/2.1.8/i18n/es-ES.json
'
            }
        });

        // Manejar la selección de un producto
        $(document).on('click', '.btnSeleccionarProducto', function() {
            var codigo = $(this).data('codigo');
            var descripcion = $(this).data('descripcion');
            var unidad = $(this).data('unidad');
            var precio = $(this).data('precio');

            // Incrementar el contador
            productCounter++;

            // Crear una fila nueva en la tabla de productos con nombres únicos
            var nuevaFila = `
                <tr>
                    <td><input type="hidden" name="productos[${productCounter}][codigo]" value="${codigo}">${codigo}</td>
                    <td><input type="hidden" name="productos[${productCounter}][descripcion]" value="${descripcion}">${descripcion}</td>
                    <td><input type="hidden" name="productos[${productCounter}][unidad]" value="${unidad}">${unidad}</td>
                    <td><input type="number" name="productos[${productCounter}][cantidad]" class="form-control cantidad" value="1"></td>
                    <td><input type="number" name="productos[${productCounter}][valor_unitario]" class="form-control valor_unitario" value="${parseFloat(precio).toFixed(2)}"></td>
                    <td><input type="number" name="productos[${productCounter}][descuento]" class="form-control descuento" value="0"></td>
                    <td class="total">${parseFloat(precio).toFixed(2)}</td>
                    <td><button class="btn btn-danger btnEliminarProducto"><i class="fas fa-trash-alt"></i></button></td>
                </tr>`;

            $('#tablaProductos tbody').append(nuevaFila);

            // Cerrar el modal
            $('#modalBuscarProducto').modal('hide');

            calcularTotales(); // Recalcular totales al agregar un nuevo producto
        });

        // Manejar la eliminación de un producto
        $(document).on('click', '.btnEliminarProducto', function() {
            $(this).closest('tr').remove();
            calcularTotales(); // Recalcular los totales después de eliminar
        });

        // Recalcular el total al cambiar cantidad, descuento o precio unitario
        $(document).on('input', '.cantidad, .descuento, .valor_unitario', function() {
            var row = $(this).closest('tr');
            var cantidad = parseFloat(row.find('.cantidad').val()) || 0; // Cantidad
            var valor_unitario = parseFloat(row.find('.valor_unitario').val()) || 0; // Precio unitario
            var descuento = parseFloat(row.find('.descuento').val()) || 0; // Descuento en %

            // Calcular el subtotal
            var subtotal = cantidad * valor_unitario;

            // Aplicar descuento como porcentaje
            var descuentoAplicado = (subtotal * descuento) / 100;

            // Calcular el total de la fila
            var total = subtotal - descuentoAplicado;

            // Actualizar la celda total con 2 decimales
            row.find('.total').text(total.toFixed(2));

            // Recalcular totales generales
            calcularTotales();
        });

        // Función para calcular los totales generales
        function calcularTotales() {
            let subtotalGeneral = 0;
            let totalDescuentos = 0;
            let totalGeneral = 0;

            $('#tablaProductos tbody tr').each(function() {
                const cantidad = parseFloat($(this).find('.cantidad').val()) || 0;
                const valor_unitario = parseFloat($(this).find('.valor_unitario').val()) || 0;
                const descuento = parseFloat($(this).find('.descuento').val()) || 0;

                const subtotal = cantidad * valor_unitario;
                const descuentoAplicado = (subtotal * descuento) / 100;
                const total = subtotal - descuentoAplicado;

                subtotalGeneral += subtotal-descuentoAplicado;
                totalDescuentos += descuentoAplicado;
                totalGeneral += total;
            });

            $('#subtotalGeneral').val(subtotalGeneral.toFixed(2));
            $('#totalDescuentos').val(totalDescuentos.toFixed(2));
            $('#totalGeneral').val(totalGeneral.toFixed(2));
            //$('#subtotalGeneral_1').val(subtotalGeneral.toFixed(2));
        }
    });
</script>



<script>
    function calcularTotales() {
    let subtotal = 0;
    let descuentoGlobal = 0; // Descuento global (si aplica)
    let inafecta = 0; // Suma de productos inafectos
    let exonerada = 0; // Suma de productos exonerados
    let totalDescuento = 0; // Total del descuento aplicado

    // Iterar sobre las filas de la tabla de productos
    $('#tablaProductos tbody tr').each(function () {
        const cantidad = parseFloat($(this).find('.cantidad').val()) || 0; // Cantidad
        const valorUnitario = parseFloat($(this).find('.valor_unitario').val()) || 0; // Valor unitario
        const descuento = parseFloat($(this).find('.descuento').val()) || 0; // Descuento en %

        // Calcular el subtotal de la fila
        const subtotalFila = cantidad * valorUnitario;

        // Aplicar descuento
        const descuentoAplicado = (subtotalFila * descuento) / 100;

        // Sumar al total del descuento global
        totalDescuento += descuentoAplicado;

        // Calcular el total de la fila
        const totalFila = subtotalFila - descuentoAplicado;

        // Actualizar el valor en la columna "total"
        $(this).find('.total').text(totalFila.toFixed(2));

        // Sumar al subtotal general
        subtotal += totalFila;

        // Si este producto es inafecto o exonerado, puedes sumar a sus valores
        // (Esto depende de tu lógica, por ejemplo, por tipo de producto)
        // Ejemplo:
        // if (esInafecto) inafecta += totalFila;
        // if (esExonerado) exonerada += totalFila;
    });

    // Calcular IGV (18%)
    const igv = subtotal * 0.18;

    // Total general
    const total = subtotal + igv;

    // Actualizar los campos en la tabla de totales
    $('#subtotal').text(`$${subtotal.toFixed(2)}`);
    $('#descuento').text(`$${descuentoGlobal.toFixed(2)}`);
    $('#inafecta').text(`$${inafecta.toFixed(2)}`);
    $('#exonerada').text(`$${exonerada.toFixed(2)}`);
    $('#igv').text(`$${igv.toFixed(2)}`);
    $('#total_descuento').text(`$${totalDescuento.toFixed(2)}`);
    $('#total').text(`$${total.toFixed(2)}`);
}

</script> <?php /**PATH C:\laragon\www\Sistema-web\resources\views/admin/pedidos/invocacion-datos.blade.php ENDPATH**/ ?>