<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content_header'); ?>
    <a href="<?php echo e(route('admin.roles.create')); ?>" class="btn btn-primary float-right text-nowrap">
        <i class="fas fa-plus-circle"></i> Registrar
    </a>
    <h1 class="font-weight-bold">Lista de Roles</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body table-responsive">
            <table class="table table-bordered table-hover">
                <thead class="border">
                    <tr>
                        <th>Item</th>
                        <th>Rol</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td width="20px"><?php echo e($loop->iteration); ?></td>
                            <td><?php echo e($role->name); ?></td>
                            <td width="260px">
                                <div class="d-flex" style="gap: 10px">
                                    <a href="<?php echo e(route('admin.roles.edit', $role)); ?>"
                                        class="btn btn-sm btn-success text-nowrap">
                                        <i class="fas fa-pen"></i>
                                    </a>
									<a href="<?php echo e(route('admin.roles.show', $role)); ?>"
                                        class="btn btn-sm btn-info text-nowrap">
                                        <i class="fas fa-eye"></i>
                                    </a>

                                    <form action="<?php echo e(route('admin.roles.destroy', $role)); ?>" method="POST"
                                        class="form-delete text-nowrap">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-danger"><i
                                                class="fas fa-minus-circle"></i> </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

    <?php if(session('success')): ?>
        <script>
            Swal.fire({
                icon: 'success',
                title: 'El rol se eliminó con éxito',
            })
        </script>
    <?php endif; ?>

    <script>
        $('.form-delete').submit(function(e) {
            e.preventDefault()
            Swal.fire({
                title: '¿Estás seguro?',
                text: "Elija la opción Eliminar para confirmar.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    this.submit();
                }
            })
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\Sistema-web\resources\views/admin/roles/index.blade.php ENDPATH**/ ?>