<?php $__env->startSection('title', 'Registrar Clientes'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1 class="text-bold">Registrar hola</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <h3>Cliente</h3>
    <form wire:submit.prevent="save">
        <div class="row">
            <!-- Código -->
            <div class="col-md-6">
                <label for="codigo">Código</label>
                <input type="text" id="codigo" class="form-control" wire:model="cliente.codigo" placeholder="Ingrese el código" readonly>
            </div>

            <div class="col-md-6 d-flex align-items-center">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="activo">
                    <label class="form-check-label" for="activo">Activo</label>
                </div>
                <div class="form-check ms-3">
                    <input class="form-check-input" type="checkbox" id="agente_retendedor">
                    <label class="form-check-label" for="agente_retendedor">Agente Retenedor</label>
                </div>
            </div>
        </div>

        <div class="row mt-3">
            <!-- Tipo de documento -->
            <div class="col-md-6">
                <label for="tipo_documento">Tipo de Documento</label>
                <select id="tipo_documento" class="form-control" >
                    <option value="">--Seleccione--</option>
                    <option value="DNI">DNI</option>
                    <option value="RUC">RUC</option>
                </select>
            </div>

            <!-- Documento -->
            <div class="col-md-6">
                <label for="documento">Documento</label>
                <div class="input-group">
                    <input type="text" id="documento" class="form-control" >
                    <button type="button" class="btn btn-primary">Sunat</button>
                </div>
            </div>
        </div>

        <div class="row mt-3">
            <!-- Nombres o Razón -->
            <div class="col-md-12">
                <label for="nombres_razon">Nombres o Razón</label>
                <input type="text" id="nombres_razon" class="form-control">
            </div>
        </div>

        <div class="row mt-3">
            <!-- Ubicación -->
            <div class="col-md-3">
                <label for="pais">País</label>
                <select name="pais" id="pais" class="form-control" onchange="buscar_departamento()">
                    <option value="">--seleccione--</option>
                    <?php $__currentLoopData = $paises; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pais): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($pais->cdg_pais); ?>"><?php echo e($pais->des_pais); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-3">
                <label for="departamento">Departamento</label>
                <select name="departamento" id="departamento" class="form-control" onchange="buscar_provincia()">
                    <option value="">--seleccione--</option>
                   
                </select>
            </div>
            <div class="col-md-3">
                <label for="provincia">Provincia</label>
                <select name="provincia" id="provincia" class="form-control" onchange="buscar_distrito()">
                    <option value="">--seleccione--</option>
                   
                </select>
            </div>
            <div class="col-md-3">
                <label for="distrito">Distrito</label>
                <select name="distrito" id="distrito" class="form-control">
                    <option value="">--seleccione--</option>
                   
                </select>
            </div>
        </div>

        <div class="row mt-3">
            <!-- Dirección -->
            <div class="col-md-12">
                <label for="direccion">Dirección</label>
                <input type="text" id="direccion" class="form-control">
            </div>
        </div>

        <div class="row mt-3">
            <!-- Tipo Cliente -->
            <div class="col-md-6">
                <label>Tipo Cliente</label>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="tipo_cliente" id="persona_juridica" value="Persona Juridica">
                    <label class="form-check-label" for="persona_juridica">Persona Jurídica</label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="tipo_cliente" id="persona_natural" value="Persona Natural">
                    <label class="form-check-label" for="persona_natural">Persona Natural</label>
                </div>
            </div>

            <!-- Contacto -->
            <div class="col-md-3">
                <label for="contacto">Contacto</label>
                <input type="text" id="contacto" name="contacto" class="form-control">
            </div>

            <!-- Teléfono -->
            <div class="col-md-3">
                <label for="telefono">Teléfono</label>
                <input type="text" id="telefono" name="telefono" class="form-control" oninput="digitotele(this,11)">
            </div>
        </div>

        <div class="row mt-4">
            <!-- Botones -->
            <div class="col-md-12 text-end">
                <button type="button" class="btn btn-secondary">Cerrar</button>
                <button type="submit" class="btn btn-primary">Guardar</button>
            </div>
        </div>
    </form>
</div>

<script>
        function digito(input,maxdigitos){
            input.value=input.value.replace(/\D/g,'');
            if(input.value.length>maxdigitos){
                input.value=input.value.slice(0,maxdigitos)
            }
        }
        function digitotele(input,maxdigitos){
            input.value=input.value.replace(/\D/g,'');
            if(input.value.length>maxdigitos){
                input.value=input.value.slice(0,maxdigitos)
            }
        }
    function buscar_departamento(){
            let codigo_pais=$('#pais').val();
            $.ajax({
                type:"POST",
                dataType: "json",
                data:{
                    "codigo_pais": codigo_pais,
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                },
                url:"<?php echo e(route('admin.distribuidores.departamento')); ?>",
                success:function(resultado){
                    $('#departamento').html(resultado.html)
                }
            })
        }

        function buscar_provincia(){
            let codigo_pais=$('#pais').val();
            let codigo_departamento=$('#departamento').val();
            //console.log(codigo_pais+''+codigo_departamento);
            $.ajax({
                type:"POST",
                dataType: "json",
                data:{
                    "codigo_pais": codigo_pais,
                    "codigo_departamento": codigo_departamento,
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                },
                url:"<?php echo e(route('admin.distribuidores.provincia')); ?>",
                success:function(resultado){
                    $('#provincia').html(resultado.html)
                }
            })
        }

        function buscar_distrito(){
            let codigo_pais=$('#pais').val();
            let codigo_provincia=$('#provincia').val();
            console.log(codigo_pais+''+codigo_provincia);
            $.ajax({
                type:"POST",
                dataType: "json",
                data:{
                    "codigo_pais": codigo_pais,
                    "codigo_provincia": codigo_provincia,
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                },
                url:"<?php echo e(route('admin.distribuidores.distrito')); ?>",
                success:function(resultado){
                    $('#distrito').html(resultado.html)
                }
            })
        }
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\Sistema-web\resources\views/admin/clientes/create.blade.php ENDPATH**/ ?>