<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\ProductosController;
use App\Http\Controllers\Admin\DistribuidoresController;
use App\Http\Controllers\Admin\CotizacionesController;
use App\Http\Controllers\Admin\PedidosController;
use App\Http\Controllers\Admin\ClientesController;
use App\Http\Controllers\Admin\PerfilController;
use App\Http\Controllers\Admin\CambioController;
use App\Http\Controllers\Admin\CompraPeriodoController;
use App\Http\Controllers\Admin\DetalleCompraController;
use App\Http\Controllers\Admin\RedesController;
use App\Models\Distribuidor;
use Whoops\Run;

// Redirección a la página de login por defecto
Route::get('/', function () {
    return redirect('/login');
});

// Middleware para proteger las rutas de usuarios autenticados
Route::middleware(['auth:sanctum', config('jetstream.auth_session'), 'verified'])->group(function () {
    // Dashboard
    Route::get('/dashboard', function () {
        return view('/admin.index'); // Vista principal extendiendo AdminLTE
    })->name('dashboard');

    // Perfil
    Route::get('perfil', [PerfilController::class, 'index'])
        ->name('admin.perfil.index')
        ->middleware('can:admin.perfil.index');

    // Usuarios y Roles
    Route::resource('users', UserController::class)
        ->names('admin.users')
        ->middleware('can:admin.users.index');

    Route::get('roles/generate-permissions', [RoleController::class, 'generatePermissions'])
         ->name('admin.roles.generate-permissions')
        ->middleware('can:admin.roles.index');
        
    Route::resource('roles', RoleController::class)
        ->names('admin.roles')
        ->middleware('can:admin.roles.index');

    

    // Productos
    Route::resource('productos', ProductosController::class)
        ->names('admin.productos')
        ->middleware('can:admin.productos.index');

    Route::get('/productos/obtener-productos', [ProductosController::class, 'obtenerProductosPorAlmacen'])
        ->name('admin.productos.obtenerProductosPorAlmacen')
        ->middleware('can:admin.productos.index');

    
    // Cotizaciones
    Route::get('cotizaciones/clientes', [CotizacionesController::class, 'getClientes'])->name('admin.cotizaciones.getClientes');
    Route::post('selectProducto/',[CotizacionesController::class,'cestaproducto'])->name('cotizaciones.cesta');
    Route::post('limpiarcesta/',[CotizacionesController::class,'limpiar'])->name('cotizaciones.limpiar');
    Route::post('eliminaproducto/',[CotizacionesController::class,'eliminar'])->name('cotizaciones.elimina');
    Route::post('cambiacantidad/',[CotizacionesController::class,'cambiar'])->name('cotizaciones.cambiar');
    Route::post('cambiaafect/',[CotizacionesController::class,'seleccionar'])->name('cotizaciones.afectacion');
    // Cotizaciones
    Route::resource('cotizaciones', CotizacionesController::class)
        ->names('admin.cotizaciones')
        ->middleware('can:admin.cotizaciones.index'); 
     
    // Pedidos
    
    Route::resource('pedidos', PedidosController::class)
        ->names('admin.pedidos')
        ->middleware('can:admin.pedidos.index');
    
    // Clientes
    
    Route::post('/obtenerCliente', [ClientesController::class, 'getcliente'])->name('obtener.cliente');
    Route::resource('clientes', ClientesController::class)
        ->names('admin.clientes')
        ->middleware('can:admin.clientes.index');

    // Distribuidores
    Route::put('/cambiarestado/{codigo}',[DistribuidoresController::class,'activo'])->name('admin.distribuidores.activo');
    Route::post('/distribuidores/cambiar-estado-web-masivo', [DistribuidoresController::class, 'cambiarEstadoWebMasivo'])
    ->name('admin.distribuidores.cambiarEstadoWebMasivo'); 
    Route::get('/distribuidores/perfil',[DistribuidoresController::class,'perfil'])->name('admin.distribuidores.perfil');
    Route::prefix('distribuidores')->name('admin.distribuidores.')->middleware('can:admin.distribuidores.index')->group(function () {
        Route::get('/', [DistribuidoresController::class, 'index'])->name('index');
        Route::get('/crear', [DistribuidoresController::class, 'create'])->name('create');
        Route::post('/crear', [DistribuidoresController::class, 'store'])->name('store');
        Route::get('/editar/{codigo}', [DistribuidoresController::class, 'edit'])->name('edit');
        Route::put('/editar/{codigo}', [DistribuidoresController::class, 'update'])->name('update');
        Route::delete('/eliminar/{codigo}', [DistribuidoresController::class, 'destroy'])->name('destroy');
        Route::post('/departamento', [DistribuidoresController::class, 'departamento'])->name('departamento');
        Route::post('/provincia', [DistribuidoresController::class, 'provincia'])->name('provincia');
        Route::post('/distrito', [DistribuidoresController::class, 'distrito'])->name('distrito');
        
        
    });

    // redes
    Route::resource('redes', RedesController::class)
        ->names('admin.redes');
        //->middleware('can:admin.redes.index');

    //compras
    Route::resource('compra',CompraPeriodoController::class)->names('admin.compra');
    Route::resource('detallacompra',DetalleCompraController::class)->names('admin.detallecompra');

    Route::resource('cambio', CambioController::class)->names('admin.cambio');

});
