<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <div class="input-group" style="width: 500px;">
            <input wire:model.defer="search" wire:keydown.enter="buscar" class="form-control" type="text" placeholder="Buscar por Codigo de pedido o RUC">
            <button wire:click="buscar" class="btn btn-primary">Buscar</button>
        </div>
    </div>

    @if ($pedidos->count())
        <div class="card-body" style="overflow: hidden">
            <div>
                {{ $pedidos->links() }}
            </div>
            <div class="table-responsive">
                <table class="table table-bordered table-hover">
                    <thead class="border text-center">
                        <tr>
                            <th>Item</th>
                            <th>Número Pedido</th>
                            <th>Vendedor</th>
                            <th>Forma de Pago</th>
                            <th>Moneda</th>
                            <th>Fecha Pedido</th>
                            <th>Número OC</th>
                            <th>Número Cotización</th>
                            <th>RUC Cliente</th>
                            <th>Nombre Cliente</th>
                            <th>Fecha Entrega</th>
                            <th>Fecha Vencimiento</th>
                            <th>Almacén</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($pedidos as $index => $pedido)
                            <tr>
                                <td>{{ $pedidos->perPage() * ($pedidos->currentPage() - 1) + $loop->iteration }}</td>
                                <td>{{ $pedido->Num_ped }}</td>
                                <td>{{ $pedido->Des_vend }}</td>
                                <td>{{ $pedido->FOR_PAGO }}</td>
                                <td>{{ $pedido->MONEDA }}</td>
                                <td>{{ $pedido->Fec_ped }}</td>
                                <td>{{ $pedido->Num_ocom }}</td>
                                <td>{{ $pedido->Num_cot }}</td>
                                <td>{{ $pedido->Ruc_cli }}</td>
                                <td>{{ $pedido->Des_cli }}</td>
                                <td>{{ $pedido->FEC_ENT }}</td>
                                <td>{{ $pedido->FEC_VENC }}</td>
                                <td>{{ $pedido->ALMACEN }}</td>
                                <td width="200px">
                                    <div class="d-flex" style="gap: 10px">
                                        <button class="btn btn-sm btn-info">
                                            <i class="fas fa-pen"></i>
                                        </button>
                                        <button class="btn btn-sm btn-success">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger">
                                            <i class="fas fa-minus-circle"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    @else
        <div class="card-body">
            <strong>Sin registros</strong>
        </div>
    @endif
</div>
