<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <div class="input-group" style="width: 300px;">
            <input wire:model.defer="search" wire:keydown.enter="buscar" class="form-control" type="text" placeholder="Buscar por Nombre o Código...">
            <button wire:click="buscar" class="btn btn-primary">Buscar</button>
        </div>
    </div>

    @if ($distribuidores->count())
        <div class="card-body" style="overflow: hidden">
            <div>
                {{ $distribuidores->links() }}
            </div>
            <div class="table-responsive">
                <table class="table table-bordered table-hover">
                    <thead class="border text-center">
                        <tr>
                            <th>Item</th>
                            <th>Código Distribuidor</th>
                            <th>Nombre Completo</th>
                            <th>Dirección</th>
                            <th>Teléfono</th>
                            <th>Email</th>
                            <th>Estado</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($distribuidores as $index => $distribuidor)
                            <tr>
                                <td>{{ $distribuidores->perPage() * ($distribuidores->currentPage() - 1) + $loop->iteration }}</td>
                                <td>{{ $distribuidor->cdg_dist }}</td>
                                <td>{{ $distribuidor->NOM_DIS }}</td>
                                <td>{{ $distribuidor->dir_dist }}</td>
                                <td>{{ $distribuidor->tel_dist }}</td>
                                <td>{{ $distribuidor->ema_dist }}</td>
                                <td>{{ $distribuidor->ESTADO }}</td>
                                <td width="200px">
                                    <div class="d-flex" style="gap: 10px">
                                        <button class="btn btn-sm btn-info">
                                            <i class="fas fa-pen"></i>
                                        </button>
                                        <button class="btn btn-sm btn-success">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger">
                                            <i class="fas fa-minus-circle"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    @else
        <div class="card-body">
            <strong>Sin registros</strong>
        </div>
    @endif
</div>
