<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <div class="input-group" style="width: 300px;">
            <input wire:model.defer="search" wire:keydown.enter="buscar" class="form-control" type="text" placeholder="Buscar por Codigo o RUC">
            <button wire:click="buscar" class="btn btn-primary">Buscar</button>
        </div>
    </div>
    @if ($cotizaciones->count())
        <div class="card-body" style="overflow: hidden">
            <div>
                {{ $cotizaciones->links() }}
            </div>
            <div class="table-responsive">
                <table class="table table-bordered table-hover">
                    <thead class="border text-center">
                        <tr>
                            <th>Item</th>
                            <th>Número Cotización</th>
                            <th>Vendedor</th>
                            <th>Forma de Pago</th>
                            <th>Condición de Pago</th>
                            <th>Moneda</th>
                            <th>Fecha Cotización</th>
                            <th>Número OC</th>
                            <th>RUC Cliente</th>
                            <th>Nombre Cliente</th>
                            <th>Fecha Entrega</th>
                            <th>Almacén</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($cotizaciones as $index => $cotizacion)
                            <tr>
                                <td>{{ $cotizaciones->perPage() * ($cotizaciones->currentPage() - 1) + $loop->iteration }}</td>
                                <td>{{ $cotizacion->Num_cot }}</td>
                                <td>{{ $cotizacion->Des_vend }}</td>
                                <td>{{ $cotizacion->FORMA_PAGO }}</td>
                                <td>{{ $cotizacion->COND_PAGO }}</td>
                                <td>{{ $cotizacion->MONEDA }}</td>
                                <td>{{ $cotizacion->Fec_cot }}</td>
                                <td>{{ $cotizacion->Num_oCom }}</td>
                                <td>{{ $cotizacion->Ruc_cli }}</td>
                                <td>{{ $cotizacion->Des_cli }}</td>
                                <td>{{ $cotizacion->fec_ent }}</td>
                                <td>{{ $cotizacion->ALMACEN }}</td>
                                <td width="200px">
                                    <div class="d-flex" style="gap: 10px">
                                        <button class="btn btn-sm btn-info">
                                            <i class="fas fa-pen"></i>
                                        </button>
                                        <button class="btn btn-sm btn-success">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger">
                                            <i class="fas fa-minus-circle"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    @else
        <div class="card-body">
            <strong>Sin registros</strong>
        </div>
    @endif
</div>
