@extends('adminlte::page')

@section('title', 'Crear Usuario')

@section('content_header')
    <a href="{{ route('admin.users.index') }}" class="float-right mt-2">
        <i class="fas fa-chevron-circle-left"></i> Ver lista de usuarios
    </a>
    <h1 class="text-bold">Crear Usuario</h1>
@stop

@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('admin.users.store') }}" method="POST">
                @csrf
                <div class="form-group">
                    <div class="row">
                        <div class="col-6">
                            <label for="name">Nombre</label>
                            <input type="text" name="name" id="name" class="form-control" value="{{ old('name') }}">
                            @error('name')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
                        <div class="col-6">
                            <label for="email">Usuario web</label>
                            <input type="text" name="email" id="email" class="form-control" value="{{ old('email') }}">
                            @error('email')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="row">
                        <div class="col-6">
                            <label for="password">Contraseña</label>
                            <input type="password" name="password" id="password" class="form-control">
                            @error('password')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
                        <div class="col-6">
                            <label for="password_confirmation">Confirmar Contraseña</label>
                            <input type="password" name="password_confirmation" id="password_confirmation" class="form-control">
                            @error('password_confirmation')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
                    </div>
                </div>
                <label for="roles">Rol</label>
                <div class="form-group border rounded-lg p-2">
                    @foreach ($roles as $role)
                        <div>
                            <label>
                                <input type="checkbox" name="roles[]" value="{{ $role->id }}" class="mr-1">
                                {{ $role->name }}
                            </label>
                        </div>
                    @endforeach
                </div>
                <div class="float-right">
                    <button type="submit" class="btn btn-primary">Guardar</button>
                    <a href="{{ url()->previous() }}" class="btn btn-danger ml-1">Cancelar</a>
                </div>
            </form>
        </div>
    </div>
@stop
