@extends('adminlte::page')

@section('title', 'Ver Rol')

@section('content_header')
    <a href="{{ route('admin.roles.index') }}" class="float-right mt-2">
        <i class="fas fa-chevron-circle-left"></i> Ver lista de roles
    </a>
    <h1 class="text-bold">Ver Rol</h1>
@stop

@section('content')
    <div class="card">
        <div class="card-header d-flex flex-wrap justify-content-between align-items-center">
            <h5 class="flex-grow-1">Rol: <span class="badge badge-warning">{{ $role->name }}</span></h5>
            <a href="{{ route('admin.roles.edit', $role) }}" class="btn btn-sm btn-success text-nowrap">
                <i class="fas fa-pen"></i> Editar
            </a>
        </div>
        <div class="card-body">
            <!-- Campo para el nombre del rol -->
            <div class="form-group">
                <label for="name" class="font-weight-bold">Nombre del rol</label>
                <input type="text" id="name" class="form-control-plaintext" value="{{ $role->name }}" readonly>
            </div>

            <!-- Lista de permisos estructurados -->
            <h5 class="font-weight-bold">Lista de Permisos</h5>
            <ul class="list-group">
                @foreach ($structuredPermissions as $category)
                    <li class="list-group-item">
                        <i class="fas fa-folder-open"></i> {{ $category['text'] }}
                        @if (!empty($category['submenu']))
                            <ul class="list-group mt-2">
                                @foreach ($category['submenu'] as $permission)
                                    <li class="list-group-item">
                                        {{ $permission['text'] }}
                                        @if (!empty($permission['submenu']))
                                            <ul class="mt-2 submenu-list">
                                                @foreach ($permission['submenu'] as $subpermission)
                                                    <li class="list-group-item">
                                                        {{ $subpermission['text'] }}
                                                    </li>
                                                @endforeach
                                            </ul>
                                        @endif
                                    </li>
                                @endforeach
                            </ul>
                        @endif
                    </li>
                @endforeach
            </ul>
        </div>
    </div>
@stop

@section('js')
    @if (session('success') == 'update')
        <script>
            Swal.fire({
                icon: 'success',
                title: 'El rol se editó con éxito',
            })
        </script>
    @endif
@stop
