@extends('adminlte::page')

@section('title', 'Productos')

@section('content_header')

    <h1>Lista de Productos</h1>
@endsection

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">

        {{-- Filtro por almacén --}}
        <form action="{{ route('admin.productos.index') }}" method="GET" class="d-flex align-items-center" style="gap: 10px;">
            {{-- Campo de selección de almacén --}}
            <select name="almacen" class="form-control">
                <option value="">Todos los almacenes</option>
                @foreach ($almacenes as $alm)
                    <option value="{{ trim($alm->Des_item) }}" {{ request('almacen') == trim($alm->Des_item) ? 'selected' : '' }}>
                        {{ $alm->Des_item }}
                    </option>
                @endforeach
            </select>

            {{-- Campo oculto para mantener el término de búsqueda si está aplicado --}}
            {{-- <input type="hidden" name="search" value="{{ request('search') }}">--}}

            {{-- Botón para filtrar por almacén --}}
            <button class="btn btn-primary" type="submit">Aplicar filtro</button>
        </form>




        {{-- Paginador --}}
        @include('admin.paginador.index', ['data' => $data])
    </div>
    <div class="card-header d-flex justify-content-between align-items-center">
         {{-- Buscador --}}
         <form action="{{ route('admin.productos.index') }}" method="GET" class="d-flex align-items-center" style="gap: 10px;">
            {{-- Campo de búsqueda --}}
            <input name="search" class="form-control" type="text" placeholder="Buscar productos por, nombre, codigo, familia o linea" value="{{ request('search') }}" autocomplete="off">

            {{-- Campo oculto para mantener el filtro por almacén si está aplicado --}}
            <input type="hidden" name="almacen" value="{{ request('almacen') }}">

            {{-- Botón de búsqueda --}}
            <button class="btn btn-primary" type="submit">Buscar</button>
        </form>
    </div>
    {{-- Tabla de Productos --}}
    @if ($data['items']->count())
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover">
                    <thead class="border text-center">
                        <tr>
                            <th>ID</th> {{-- Columna para el número de ítem --}}
                            <th>Código</th>
                            <th>Descripción</th>
                            <th>Familia</th>
                            <th>Línea</th>
                            <th>Tipo</th>
                            <th>Unidad de Medida</th>
                            <th>Precio (S/.)</th>
                            <th>Precio (USD)</th>
                            <th>Stock Actual</th>
                            <th>Estado</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($data['items'] as $producto)
                            <tr>
                                <td>{{ $data['tamanio'] * ($data['pagina'] - 1) + $loop->iteration }}</td>
                                <td>{{ $producto->Cdg_prod }}</td>
                                <td>{{ $producto->Des_prod }}</td>
                                <td>{{ $producto->Familia }}</td>
                                <td>{{ $producto->Linea }}</td>
                                <td>{{ $producto->Tipo }}</td>
                                <td>{{ $producto->UNM }}</td>
                                <td>{{ $producto->Val_sol }}</td>
                                <td>{{ $producto->Val_dol }}</td>
                                <td>{{ $producto->Stk_act }}</td>
                                <td>{{ $producto->swt_est == 1 ? 'Activo' : 'Inactivo' }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    @else
        {{-- Mensaje cuando no hay registros --}}
        <div class="card-body text-center">
            <strong>No se encontraron registros con los filtros aplicados.</strong>
        </div>
    @endif
</div>



@endsection


