@extends('adminlte::page')

@section('title', 'Listado de Pedidos')

@section('content_header')
<a class="btn btn-primary float-right mb-3 mb-md-0" href="{{ route('admin.pedidos.create') }}">
    <i class="fas fa-plus-circle"></i> Registrar Pedido
</a>
    <h1 class="text-bold">Lista de Pedidos</h1>
@stop

@section('content')
    <!-- Livewire Component -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            {{-- Buscador --}}
            <form action="{{ route('admin.pedidos.index') }}" method="GET" class="d-flex" style="gap: 10px; width: 50%;">
                <input name="search" class="form-control" type="text" placeholder="Buscar por Número de Pedido, Vendedor, Ruc o Cliente" value="{{ request('search') }}">
                <button class="btn btn-primary" type="submit">Buscar</button>
            </form>

            {{-- Paginador --}}
            @include('admin.paginador.index', ['data' => $data])
        </div>

        {{-- Tabla de Pedidos --}}
        @if ($data['pedidos']->count())
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="border text-center">
                            <tr>
                                <th>ID</th>
                                <th>Número</th>
                                <th>Vendedor</th>
                                <th>Forma de Pago</th>
                                <th>Moneda</th>
                                <th>Fecha Pedido</th>
                                <th>Orden Compra</th>
                                <th>Cotización</th>
                                <th>RUC Cliente</th>
                                <th>Cliente</th>
                                <th>Fecha Entrega</th>
                                <th>Fecha Vencimiento</th>
                                <th>Almacén</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($data['pedidos'] as $pedido)
                                <tr>
                                    <td>{{ $data['tamanio'] * ($data['pagina'] - 1) + $loop->iteration }}</td>
                                    <td>{{ $pedido->Num_ped }}</td>
                                    <td>{{ $pedido->Des_vend }}</td>
                                    <td>{{ $pedido->FOR_PAGO }}</td>
                                    <td>{{ $pedido->MONEDA }}</td>
                                    <td>{{ $pedido->Fec_ped }}</td>
                                    <td>{{ $pedido->Num_ocom }}</td>
                                    <td>{{ $pedido->Num_cot }}</td>
                                    <td>{{ $pedido->Ruc_cli }}</td>
                                    <td>{{ $pedido->Des_cli }}</td>
                                    <td>{{ $pedido->FEC_ENT }}</td>
                                    <td>{{ $pedido->FEC_VENC }}</td>
                                    <td>{{ $pedido->ALMACEN }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        @else
            <div class="card-body">
                <strong>Sin registros</strong>
            </div>
        @endif
    </div>

@stop
