<nav aria-label="Page navigation">
    <ul class="pagination mb-0">
        {{-- Botón "Anterior" --}}
        <li class="page-item {{ $data['pagina'] == 1 ? 'disabled' : '' }}">
            <a class="page-link" href="?pagina={{ $data['pagina'] - 1 }}&search={{ $data['search'] }}&tamanio={{ $data['tamanio'] }}">‹</a>
        </li>

        {{-- Lógica para puntos suspensivos y páginas visibles --}}
        @php
            $start = max(1, $data['pagina'] - 2);
            $end = min($data['total_paginas'], $data['pagina'] + 2);
        @endphp

        {{-- Primera página y puntos suspensivos --}}
        @if ($start > 1)
            <li class="page-item">
                <a class="page-link" href="?pagina=1&search={{ $data['search'] }}&tamanio={{ $data['tamanio'] }}">1</a>
            </li>
            @if ($start > 2)
                <li class="page-item disabled"><span class="page-link">...</span></li>
            @endif
        @endif

        {{-- Páginas visibles --}}
        @for ($i = $start; $i <= $end; $i++)
            <li class="page-item {{ $data['pagina'] == $i ? 'active' : '' }}">
                <a class="page-link" href="?pagina={{ $i }}&search={{ $data['search'] }}&tamanio={{ $data['tamanio'] }}">{{ $i }}</a>
            </li>
        @endfor

        {{-- Última página y puntos suspensivos --}}
        @if ($end < $data['total_paginas'])
            @if ($end < $data['total_paginas'] - 1)
                <li class="page-item disabled"><span class="page-link">...</span></li>
            @endif
            <li class="page-item">
                <a class="page-link" href="?pagina={{ $data['total_paginas'] }}&search={{ $data['search'] }}&tamanio={{ $data['tamanio'] }}">{{ $data['total_paginas'] }}</a>
            </li>
        @endif

        {{-- Botón "Siguiente" --}}
        <li class="page-item {{ $data['pagina'] == $data['total_paginas'] ? 'disabled' : '' }}">
            <a class="page-link" href="?pagina={{ $data['pagina'] + 1 }}&search={{ $data['search'] }}&tamanio={{ $data['tamanio'] }}">›</a>
        </li>
    </ul>
</nav>
