@extends('adminlte::page')

@section('title', 'Perfil del Distribuidores')

@section('content')
    <!-- Livewire Component --> 
    <section class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6">
              <h1>Datos Basicos</h1>
            </div>
          </div>
        </div><!-- /.container-fluid -->
      </section>
    <section class="content">
        <div class="container-fluid">
          <div class="row">
            <!-- left column -->
            <div class="col-md-12">
             
              <!-- Horizontal Form -->
              <div class="card card-info">
                <!-- /.card-header -->
                <div class="card-header">
                  <h3 class="card-title">Datos Personales</h3>
                </div>
                <!-- form start -->
                
                    
                @foreach ($distribuidores as $distribuidor)
                <form class="form-horizontal" method="POST" action="{{route('admin.distribuidores.update',$distribuidor->cdg_dist)}}">
                  @method('PUT')
                  @csrf
                  
                  <div class="card-body">
               
                    <div class="row">
                      <label for="inputEmail3" class="col-sm-2 col-form-label" style="text-align:right">Codigo</label>
                      <div class="col-sm-3">
                        <input class="form-control form-control-sm" type="text" name="codigo" value="{{$distribuidor->cdg_dist}}" readonly>
                      </div>
                      <label for="inputEmail3" class="col-sm-2 col-form-label" style="text-align:right">Nombre</label>
                      <div class="col-sm-5">
                        <input class="form-control form-control-sm" type="text" name="nombre" value="{{$distribuidor->nom_dist}}">
                      </div>
                    </div>
                  <div class="row">
                      <label for="inputEmail3" class="col-sm-2 col-form-label" style="text-align:right">Apelldio Paterno</label>
                      <div class="col-sm-3">
                        <input class="form-control form-control-sm" type="text" name="paterno" value="{{$distribuidor->app_dist}}" >
                      </div>
                      <label for="inputEmail3" class="col-sm-2 col-form-label" style="text-align:right">Apellido Materno</label>
                      <div class="col-sm-5">
                        <input class="form-control form-control-sm" type="text" name="materno" value="{{$distribuidor->apm_dist}}">
                      </div>
                    </div>
                    <div class="row">
                      <label for="inputEmail3" class="col-sm-2 col-form-label" style="text-align:right">Tipo Doc</label>
                      <div class="col-sm-3">
                        <select class="form-control form-control-sm" name="tipo_docu" style="width: 100%;">
                          <option value="">--seleccione--</option>
                          @foreach ($documentos as $documento)
                          @php
                              $selected=($documento->cdg_docum==$distribuidor->tdc_dist)?'selected':'';
                          @endphp
                          <option value="{{$documento->cdg_docum}}" {{$selected}}>{{$documento->descripcion}}</option>
                          @endforeach
                          
                      </select>
                      </div>
                      <label for="inputEmail3" class="col-sm-2 col-form-label" style="text-align:right">Nro Doc</label>
                      <div class="col-sm-5">
                        <input class="form-control form-control-sm" name="numdocu" type="text" value="{{$distribuidor->doc_dist}}">
                      </div>
                    </div>
                    <div class="row">
                      <label for="inputEmail3" class="col-sm-2 col-form-label" style="text-align:right">Patrocinador</label>
                      <div class="col-sm-2">
                        <input class="form-control form-control-sm" name="cdgpat" type="text" value="{{$distribuidor->cdg_pat}}" readonly>
                      </div>
                      <div class="col-sm-8">
                        <input class="form-control form-control-sm" type="text" value="{{$distribuidor->PATROCINADOR}}" readonly>
                      </div>
                    </div>
                    <div class="row">
                      <label for="inputEmail3" class="col-sm-2 col-form-label" style="text-align:right">Sexo</label>
                      <div class="col-sm-10">
                        <select name="sexo" id="sexo" class="form-control form-control-sm">
                          <option value="0" {{($distribuidor->sex_dist==0)?'selected':''}}>seleccione</option>
                          <option value="1" {{($distribuidor->sex_dist==1)?'selected':''}}>masculino</option>
                          <option value="2" {{($distribuidor->sex_dist==2)?'selected':''}}>femenino</option>
                        </select>
                      </div>
                    </div>
                    <div class="row">
                      <label for="inputEmail3" class="col-sm-2 col-form-label" style="text-align:right">Pais</label>
                      <div class="col-sm-3">
                      <select class="form-control form-control-sm" name="pais" id="pais" style="width: 100%;" onchange="buscar_departamento()">
                        <option  value="" >--seleccione--</option>
                        
                        @foreach ($paises as $pais)
                        @php
                            $selected=($pais->cdg_pais==$distribuidor->cdg_pais)?'selected':'';
                        @endphp
                        <option  value="{{$pais->cdg_pais}}" {{$selected}}>{{utf8_decode($pais->des_pais)}}</option>
                        @endforeach
                          
                      </select>
                      </div>
                      <label for="inputEmail3" class="col-sm-2 col-form-label" style="text-align:right">Departamento</label>
                      <div class="col-sm-5">
                        <select class="form-control form-control-sm" name="departamento" id="departamento" style="width: 100%;" onchange="buscar_provincia()">
                          <option  value="" >--seleccione--</option>
                          @foreach ($departamentos as $departamento)
                          @php
                            $selected=($departamento->cdg_dpto==$distribuidor->Depart && $departamento->cdg_pais==$distribuidor->cdg_pais)?'selected':'';
                          @endphp
                          <option  value="{{$departamento->cdg_dpto}}" {{$selected}}>{{utf8_decode($departamento->des_dpto)}}</option>
                          @endforeach
                     
                      </select>
                      </div>
                    </div>
                    <div class="row">
                      <label for="inputEmail3" class="col-sm-2 col-form-label"  style="text-align:right">Provincia</label>
                      <div class="col-sm-3">
                        <select class="form-control form-control-sm" name="provincia" id="provincia" style="width: 100%;" onchange="buscar_distrito()">
                          <option  value="" >--seleccione--</option>
                          @foreach ($provincias as $provincia)
                          @php
                            $selected=($provincia->cdg_prov==$distribuidor->provin && $provincia->cdg_pais==$distribuidor->cdg_pais)?'selected':'';
                          @endphp
                          <option  value="{{$provincia->cdg_prov}}" {{$selected}}>{{$provincia->des_prov}}</option>
                         @endforeach
                        
                      </select>
                      </div>
                      <label for="inputEmail3" class="col-sm-2 col-form-label" style="text-align:right">Distrito</label>
                      <div class="col-sm-5">
                        <select class="form-control form-control-sm" name="distrito" id="distrito" style="width: 100%;">
                          <option  value="" >--seleccione--</option>
                          @foreach ($distritos as $distrito)
                          @php
                            $selected=($distrito->cdg_dsto==$distribuidor->cdg_dsto && $distrito->cdg_pais==$distribuidor->cdg_pais)?'selected':'';
                          @endphp
                          <option  value="{{$distrito->cdg_dsto}}" {{$selected}}>{{utf8_decode($distrito->des_dsto)}}</option>
                          @endforeach
                          
                      </select>
                      </div>
                    </div>
                    <div class="row">
                      <label for="inputEmail3" class="col-sm-2 col-form-label" style="text-align:right">Direccion</label>
                      <div class="col-sm-10">
                        <input class="form-control form-control-sm" name="direccion" type="text" value="{{$distribuidor->dir_dist}}">
                      </div>
                    </div>
                    <div class="row">
                      <label for="inputEmail3" class="col-sm-2 col-form-label" style="text-align:right">Fecha de Nacimiento</label>
                      <div class="col-sm-3">
                        <input class="form-control form-control-sm" name="nacimiento" type="date" value="@php
                        echo date('Y-m-d',strtotime($distribuidor->nac_dist))
                     @endphp">
                      </div>
                    </div>
                    <div class="row">
                      <label for="inputEmail3" class="col-sm-2 col-form-label" style="text-align:right">Telefono de Casa</label>
                      <div class="col-sm-3">
                        <input class="form-control form-control-sm" type="text" value="">
                      </div>
                      <label for="inputEmail3" class="col-sm-2 col-form-label" style="text-align:right">Telefono Celular</label>
                      <div class="col-sm-5">
                        <input class="form-control form-control-sm" name="telefono" type="text" value="{{$distribuidor->tel_dist}}">
                      </div>
                    </div>
                    <div class="row">
                      <label for="inputEmail3" class="col-sm-2 col-form-label" style="text-align:right">Correo electronico</label>
                      <div class="col-sm-10">
                        <input class="form-control form-control-sm" name="email" type="text" value="{{$distribuidor->ema_dist}}">
                      </div>
                    </div>
                    <div class="row">
                      <label for="inputEmail3" class="col-sm-2 col-form-label" style="text-align:right">Rango</label>
                      <div class="col-sm-3">
                        <input class="form-control form-control-sm" type="text" placeholder="ZAFIRO">
                      </div>
                      <label for="inputEmail3" class="col-sm-2 col-form-label" style="text-align:right">Fecha afiliacion</label>
                      <div class="col-sm-5">
                        <input class="form-control form-control-sm" name="afil" id="afil" type="date" value="@php
                           echo date('Y-m-d',strtotime($distribuidor->fec_afil))
                        @endphp">
                      </div>
                    </div>
                    <div class="row">
                      <label for="inputPassword3" class="col-sm-2 col-form-label" style="text-align:right">Categoria</label>
                      <div class="col-sm-3">
                        <select class="form-control form-control-sm" name="" style="width: 100%;">
                          <option selected="selected">PLATINO</option>
                          <option  value="" required></option>
                      </select>
                      </div>
                    </div>
                  </div>
                  <!-- /.card-body -->
                  <div class="modal-footer"> 
                    <a class="btn btn-app bg-secondary" href="#"><i class="fa fa-window-close"></i> Cancelar</a>
                    <button type="submit" class="btn btn-app bg-cyan"><i class="fas fa-check-square"></i> Grabar</button>
                </div>
                  <!-- /.card-footer -->
                  <!-- /.card-footer -->
                  
                </form>
                @endforeach
              </div>
              <!-- /.card -->
  
            </div>
            <!--/.col (left) -->
         
          </div>
          <!-- /.row -->
        </div><!-- /.container-fluid -->
      </section>

      <script>
         function buscar_departamento(){
            let codigo_pais=$('#pais').val();
            $.ajax({
                type:"POST",
                dataType: "json",
                data:{
                    "codigo_pais": codigo_pais,
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                },
                url:"{{route('admin.distribuidores.departamento')}}",
                success:function(resultado){
                    $('#departamento').html(resultado.html)
                }
            })


        }

        function buscar_provincia(){
            let codigo_pais=$('#pais').val();
            let codigo_departamento=$('#departamento').val();
            //console.log(codigo_pais+''+codigo_departamento);
            $.ajax({
                type:"POST",
                dataType: "json",
                data:{
                    "codigo_pais": codigo_pais,
                    "codigo_departamento": codigo_departamento,
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                },
                url:"{{route('admin.distribuidores.provincia')}}",
                success:function(resultado){
                    $('#provincia').html(resultado.html)
                }
            })
        }

        function buscar_distrito(){
            let codigo_pais=$('#pais').val();
            let codigo_provincia=$('#provincia').val();
            console.log(codigo_pais+''+codigo_provincia);
            $.ajax({
                type:"POST",
                dataType: "json",
                data:{
                    "codigo_pais": codigo_pais,
                    "codigo_provincia": codigo_provincia,
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                },
                url:"{{route('admin.distribuidores.distrito')}}",
                success:function(resultado){
                    $('#distrito').html(resultado.html)
                }
            })
        }
        

      </script>
@stop
