@extends('adminlte::page')

@section('title','Mis compras por periodos')

@section('content_header')
{{-- <a class="btn btn-primary float-right mb-3 mb-md-0" href="{{ route('admin.cotizaciones.create') }}">
    <i class="fas fa-plus-circle"></i> Registrar Cotizacion
</a> --}}
    <h1 class="text-bold">Detalle Compra</h1>
@stop

@section('content')

    <!-- Livewire Component -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            {{-- Buscador --}}
            <form action="{{ request()->url() }}" method="GET" class="d-flex" style="gap: 10px; width: 50%;">
                <div class="form-row row">
                    {{-- <div class="col-md-3">
                        <label for="fechI">Desde</label>
                        <input type="date" name="fechaIni" id="fechaIni" class="form-control">
                    </div>
                    <div class="col-md-3">
                        <label for="fechF">Hasta</label>
                        <input type="date" name="fechaF" id="fechaF" class="form-control">
                    </div> --}}
                    <div class="col-md-12">
                        <label for="cliente">Num Documento o  Cod Producto</label>
                        <input name="numCo" id="numCo" class="form-control" type="text" placeholder="Buscar por Número de Cotización, Codigo de Vendedor o Cliente..." value="{{ request('search') }}">
                    </div>
                    {{-- <div class="col-md-2 align-self-end">
                        <button class="btn btn-primary" type="submit">Buscar</button>
                    </div> --}}
                </div>
            </form>
            
            {{-- Paginador --}}
            {{-- @include('admin.paginador.index', ['data' => $data]) --}}
        </div>

        {{-- Tabla de Cotizaciones --}}
        {{-- @if ($data['items']->count()) --}}
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="border text-center">
                            <tr class="bg-success">
                                {{-- <th class="text-center">Fecha de Emision</th> --}}
                                <th class="text-center">Nro. Documento</th>
                                <th class="text-center">Cod_Pro</th>
                                <th class="text-center">Nombre Producto</th>
                                <th class="text-center">cantidad</th>
                                <th class="text-center">precio unitario</th>
                                <th class="text-center">total</th>
                                <th class="text-center">PV</th>
                            </tr>
                        </thead>
                        <tbody id="detalleC">
                            @foreach ($detalles as $detalle)
                            <tr>
                                {{-- <td class="text-center">{{$detalle->fec_ped}}</td> --}}
                                <td class="text-center text-success">{{$detalle->Num_ped}}</td>
                                <td class="text-center">{{$detalle->Cdg_prod}}</td>
                                <td class="text-center">{{$detalle->Des_prod}}</td>
                                <td class="text-center">{{$detalle->Can_pprd}}</td>
                                <td class="text-center">{{$detalle->Pre_pprd}}</td>
                                <td class="text-center text-primary">{{$detalle->Imp_tprd}}</td>
                                <td class="text-center"></td>
                            </tr>
                            @endforeach
                        </tbody>
                        
                    </table>
                </div>
            </div>
    </div>

    
@stop

@section('js')
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap4.min.css">
    <!-- DataTables JS -->
    <script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap4.min.js"></script>
    
    <!-- Bootstrap -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        $(document).ready(function(){
            $('#numCo').on('keyup',function(){
                let buscar=$(this).val().toLowerCase();
                $('#detalleC tr').filter(function(){
                    $(this).toggle($(this).text().toLowerCase().indexOf(buscar)>-1)
                })
            })
            
        })
    </script>


@stop