@extends('adminlte::page')

@section('title', 'Listado de Cotizaciones')

@section('content_header')
<a class="btn btn-primary float-right mb-3 mb-md-0" href="{{ route('admin.cotizaciones.create') }}">
    <i class="fas fa-plus-circle"></i> Registrar Cotizacion
</a>
    <h1 class="text-bold">Lista de Cotizaciones</h1>
@stop

@section('content')

    <!-- Livewire Component -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            {{-- Buscador --}}
            <form action="{{ request()->url() }}" method="GET" class="d-flex" style="gap: 10px; width: 50%;">
                <input name="search" class="form-control" type="text" placeholder="Buscar por Número de Cotización, Codigo de Vendedor o Cliente..." value="{{ request('search') }}">
                <button class="btn btn-primary" type="submit">Buscar</button>
            </form>

            {{-- Paginador --}}
            @include('admin.paginador.index', ['data' => $data])
        </div>

        {{-- Tabla de Cotizaciones --}}
        @if ($data['items']->count())
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="border text-center">
                            <tr>
                                <th>ID</th>
                                <th>Número</th>
                                <th>Vendedor</th>
                                <th>Moneda</th>
                                <th>Fecha Cotización</th>
                                <th>ESTADO</th>
                                <th>RUC Cliente</th>
                                <th>Cliente</th>
                                <th>Fecha Entrega</th>
                                <th>IMPORTE</th>
                                {{-- <th colspan="3">acciones</th> --}}
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($data['items'] as $cotizacion)
                                <tr>
                                    <td>{{ $data['tamanio'] * ($data['pagina'] - 1) + $loop->iteration }}</td>
                                    <td>{{ $cotizacion->NUM_COT }}</td>
                                    <td>{{ $cotizacion->DES_VEND }}</td>
                                    <td>{{ $cotizacion->MONEDA }}</td>
                                    <td>{{ $cotizacion->FEC_COT }}</td>
                                    <td>{{ $cotizacion->ESTADO }}</td>
                                    <td>{{ $cotizacion->RUC_CLI }}</td>
                                    <td>{{ $cotizacion->DES_CLI }}</td>
                                    <td>{{ $cotizacion->FEC_REF }}</td>
                                    <td>{{ $cotizacion->IMP_TTOT }}</td>
                                    {{-- <td><span class="btn  fab fa-pinterest-p"></span></td>
                                    <td><span class="btn  fas fa-edit"></span></td>
                                    <td><span class="btn  fas fa-file-pdf"></span></td> --}}
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        @else
            <div class="card-body">
                <strong>No se encontraron registros.</strong>
            </div>
        @endif
    </div>

@stop
