@extends('adminlte::page')

@section('title', 'Listado de Clientes')

@section('content_header')
{{-- <a class="btn btn-primary float-right mb-3 mb-md-0" href="{{ route('admin.clientes.create') }}">
    <i class="fas fa-plus-circle"></i> Registrar Cliente
</a> --}}
<h1 class="text-bold">Lista de Clientes</h1>
@stop

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        {{-- Buscador --}}
        <form action="{{ route('admin.clientes.index') }}" method="GET" class="d-flex" style="gap: 10px; width: 50%;">
            <input name="search" class="form-control" type="text" placeholder="Buscar por Código de pedido o RUC" value="{{ request('search') }}">
            <button class="btn btn-primary" type="submit">Buscar</button>
        </form>

        {{-- Paginador --}}
        @include('admin.paginador.index', ['data' => $data])
    </div>

    {{-- Resultados --}}
    @if ($data['clientes']->count())
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover">
                    <thead class="border text-center">
                        <tr>
                            <th>ID</th>
                            
                            <th>RUC Cliente</th>
                            <th>Nombre Cliente</th>
                            <th>Dirección</th>
                            <th>Teléfono</th>
                            <th>Email</th>
                            <th>Estado</th>

                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($data['clientes'] as $index => $cliente)
                            <tr>
                                <td>{{ $data['tamanio'] * ($data['pagina'] - 1) + $loop->iteration }}</td>
                                <td>{{ $cliente->Ruc_cli }}</td>
                                <td>{{ $cliente->Des_cli }}</td>
                                <td>{{ $cliente->Dir_cli }}</td>
                                <td>{{ $cliente->Tel_cli }}</td>
                                <td>{{ $cliente->Ema_cli }}</td>
                                <td>{{ $cliente->ESTADO }}</td>

                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    @else
        <div class="card-body">
            <strong>Sin registros</strong>
        </div>
    @endif
</div>

@stop
