<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Distrito extends Model
{
    protected $table = 'M_DISTRITO';

    // Nombre de la conexión a usar
    protected $connection = 'sqlsrv';

    // Clave primaria
    protected $primaryKey = 'cdg_dist';
    public $incrementing = false; // No es auto-incremental
    protected $keyType = 'string'; // Tipo de datos de la clave primaria

    // Deshabilitar timestamps ya que la tabla no los tiene
    public $timestamps = false;


    // Relación: Un Distrito pertenece a un Departamento
    protected $fillable = [
        'cdg_dist', 'des_dist',
    ];
}
