<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Distribuidor extends Model
{
    protected $table = 'distribuidor';

    // Nombre de la conexión a usar
    protected $connection = 'sqlsrv';

    // Clave primaria
    protected $primaryKey = 'cdg_dist';
    public $incrementing = false; // No es auto-incremental
    protected $keyType = 'string'; // Tipo de datos de la clave primaria

    // Deshabilitar timestamps ya que la tabla no los tiene
    public $timestamps = false;

    // Campos rellenables
    protected $fillable = [
        'cdg_dist',
        'app_dist',
        'apm_dist',
        'nom_dist',
        'des_dist',
        'doc_dist',
        'dir_dist',
        'tel_dist',
        'nac_dist',
        'ema_dist',
        'cdg_bco',
        'num_cta',
        'tip_cta',
        'cdg_pat',
        'cdg_civ',
        'cdg_cob',
        'num_afil',
        'swt_dist',
        'dst_fac',
        'dir_fac',
        'des_fac',
        'ruc_dist',
        'swt_ruc',
        'cdg_usr',
        'fec_usr',
        'fec_afil',
        'sex_dist',
        'cdg_fact',
        'swt_fact',
        'nom_tia',
        'tdc_dist',
        'cdg_vend',
        'obs_dist',
        'swt_afil',
        'cdg_pais',
        'cdg_dsto',
        'cdg_cent',
        'cdg_suc',
        'codreclu',
        'swt_ext',
        'cdg_tdist',
        'cdg_lprc',
        'swt_susp',
        'cod_cat',
        'ruc_cli',
    ];

    // Define el tipo de dato de columnas si es necesari

}
