<?php

namespace App\Livewire\Productos;

use Livewire\Component;

use Illuminate\Support\Facades\DB;

class Formulario extends Component
{


    public $almacenes = [];
    public $selectedAlmacen = null;
    public $search = '';
    public $perPage = 10;

    public function mount()
    {
        // Cargar los almacenes al inicializar el componente
        $this->almacenes = DB::connection('sqlsrv')->table('d_tablas')
            ->where('Cdg_tab', 'ARE')
            ->get()
            ->toArray();
    }

    public function updatingSearch()
    {
        $this->resetPage(); // Reiniciar la paginación al buscar
    }

    public function updatingSelectedAlmacen()
    {
        $this->resetPage(); // Reiniciar la paginación al cambiar almacén
    }

    public function render()
    {
        // Construir la consulta de productos
        $query = DB::connection('sqlsrv')->table('m_produc')
            ->select('Cdg_prod', 'Des_prod', 'Cdg_linp', 'Cdg_tprd', 'Cdg_umed', 'Val_sol', 'Val_dol', 'Swt_prod', 'Stk_max', 'Stk_min', 'Ubi_prod');

        // Filtrar por almacén seleccionado
        if ($this->selectedAlmacen) {
            $query->join('d_tablas', 'm_produc.Des_prod', '=', 'd_tablas.Cdg_tab')
                ->where('d_tablas.Cdg_tab', $this->selectedAlmacen);
        }

        // Agregar búsqueda si aplica
        if ($this->search) {
            $query->where('Des_prod', 'like', '%' . $this->search . '%');
        }

        // Obtener los productos con paginación
        $productos = $query->paginate($this->perPage);

        return view('livewire.productos.pro-create', compact('productos'));
    }
}
