<?php

namespace App\Livewire\Distribuidores;

use Livewire\Component;
use Livewire\WithPagination;
use Illuminate\Support\Facades\DB;

class Lista extends Component
{
    use WithPagination;

    public $search = ''; // Campo de búsqueda
    

    public function buscar()
    {
        // Reiniciar la paginación al buscar
        $this->resetPage();
    }

    public function updatingSearch()
    {
        // Reiniciar la paginación al actualizar el campo de búsqueda
        $this->resetPage();
    }

    public function render()
    {
        // Construir la consulta para obtener los distribuidores
        $query = DB::connection('sqlsrv')
            ->table('distribuidor')
            ->select(
                'cdg_dist',
                DB::raw("RTRIM(app_dist)+' '+RTRIM(apm_dist)+', '+RTRIM(nom_dist) AS NOM_DIS"),
                'dir_dist',
                'tel_dist',
                'ema_dist',
                DB::raw("(CASE WHEN swt_dist = 1 THEN 'ACTIVO' ELSE 'INACTIVO' END) AS ESTADO")
            );

        // Filtro de búsqueda
        if (!empty($this->search)) {
            $query->where(function ($subQuery) {
                $subQuery->where(DB::raw("RTRIM(app_dist)+' '+RTRIM(apm_dist)+', '+RTRIM(nom_dist)"), 'LIKE', "%{$this->search}%")
                    ->orWhere('cdg_dist', 'LIKE', "%{$this->search}%");
            });
        }

        // Obtener resultados paginados
        $distribuidores = $query->paginate(10);

        return view('livewire.distribuidores.lista', [
            'distribuidores' => $distribuidores,
        ]);
    }
}
