<?php

namespace App\Livewire\Distribuidores;

use Livewire\Component;
use Illuminate\Support\Facades\DB;

class Formulario extends Component
{
    public $distribuidor = [
        'cdg_dist' => '',
        'ruc_cli' => '',
        'app_dist' => '',
        'apm_dist' => '',
        'cdg_bco' => '',
        'nom_dist' => '',
        'des_dist' => '',
        'doc_dist' => '',
        'dir_dist' => '',
        'tel_dist' => '',
        'nac_dist' => '',
        'ema_dist' => '',
        'cdg_pais' => '',
        'cdg_dsto' => '',
        'swt_dist' => 1, // Activo por defecto
    ];

    public $paises = []; // Lista de países
    public $distritos = []; // Lista de distritos

    public function mount()
    {
        // Cargar los datos iniciales
        $this->paises = DB::connection('sqlsrv')->table('m_pais')->pluck('des_pais', 'cdg_pais')->toArray();
        $this->distritos = DB::connection('sqlsrv')->table('m_dsto')->pluck('des_dsto', 'cdg_dsto')->toArray();
    }

    public function save()
    {
        $this->validate([
            'distribuidor.cdg_dist' => 'required|max:50',
            'distribuidor.ruc_cli' => 'required|max:8',
            'distribuidor.app_dist' => 'required|max:50',
            'distribuidor.nom_dist' => 'required|max:50',
            'distribuidor.dir_dist' => 'nullable|max:60',
            'distribuidor.tel_dist' => 'nullable|max:50',
            'distribuidor.ema_dist' => 'nullable|email|max:60',
            'distribuidor.cdg_pais' => 'required',
            'distribuidor.cdg_dsto' => 'required',
        ]);

        // Concatenar el nombre completo
        $this->distribuidor['des_dist'] = trim(
            "{$this->distribuidor['app_dist']} {$this->distribuidor['apm_dist']} {$this->distribuidor['nom_dist']}"
        );

        try {
            // Llamar al procedimiento almacenado
            DB::connection('sqlsrv')->statement('EXEC USP_WEB_INSERT_DISTRIBUIDOR
                @cdg_dist = ?, @app_dist = ?, @apm_dist = ?, @nom_dist = ?, @des_dist = ?,
                @doc_dist = ?, @dir_dist = ?, @tel_dist = ?, @nac_dist = ?, @ema_dist = ?,
                @cdg_pais = ?, @cdg_dsto = ?, @ruc_cli = ?, @swt_dist = ?', [
                $this->distribuidor['cdg_dist'],
                $this->distribuidor['app_dist'],
                $this->distribuidor['apm_dist'],
                $this->distribuidor['nom_dist'],
                $this->distribuidor['des_dist'],
                $this->distribuidor['doc_dist'],
                $this->distribuidor['dir_dist'],
                $this->distribuidor['tel_dist'],
                $this->distribuidor['nac_dist'],
                $this->distribuidor['ema_dist'],
                $this->distribuidor['cdg_pais'],
                $this->distribuidor['cdg_dsto'],
                $this->distribuidor['ruc_cli'],
                $this->distribuidor['swt_dist'],
            ]);

            session()->flash('message', 'Distribuidor agregado exitosamente.');
            $this->reset('distribuidor');
        } catch (\Exception $e) {
            session()->flash('error', 'Error al agregar el distribuidor: ' . $e->getMessage());
        }
    }

    public function render()
    {
        return view('livewire.distribuidores.formulario');
    }
}
