<?php

namespace App\Livewire\Cotizaciones;

use Livewire\Component;
use Livewire\WithPagination;
use Illuminate\Support\Facades\DB;

class Lista extends Component
{
    use WithPagination;

    public $search = ''; // Campo de búsqueda
    protected $paginationTheme = 'bootstrap'; // Estilo de AdminLTE
    
    public function buscar()
    {
        // Reiniciar la paginación al buscar

    }
    public function updatingSearch()
    {
        // Reiniciar la paginación al buscar
        $this->resetPage();
    }

    public function render()
    {
        // Construir la consulta para obtener las cotizaciones
        $query = DB::connection('sqlsrv')
            ->table('M_COTIZACION')
            ->join('m_vended', 'M_COTIZACION.Cdg_vend', '=', 'm_vended.Cdg_vend')
            ->join('d_tablas as d1', 'M_COTIZACION.Cdg_cpag', '=', 'd1.Num_item')
            ->join('d_tablas as d2', 'M_COTIZACION.Cdg_mon', '=', 'd2.Num_item')
            ->join('m_client', 'M_COTIZACION.Ruc_cli', '=', 'm_client.Ruc_cli')
            ->join('d_tablas as d3', 'M_COTIZACION.Cdg_area', '=', 'd3.Num_item')
            ->select(
                'M_COTIZACION.Num_cot',
                'm_vended.Des_vend',
                DB::raw("(CASE WHEN FOR_PAG = 1 THEN 'CONTADO' ELSE 'CREDITO' END) AS FORMA_PAGO"),
                'd1.Des_item AS COND_PAGO',
                'd2.Des_item AS MONEDA',
                'M_COTIZACION.Fec_cot',
                'M_COTIZACION.Num_oCom',
                'M_COTIZACION.Ruc_cli',
                'm_client.Des_cli',
                'M_COTIZACION.fec_ent',
                'd3.Des_item AS ALMACEN'
            )
            ->where('d1.Cdg_tab', 'FPA')
            ->where('d1.Cam_item', 'X')
            ->where('d2.Cdg_tab', 'MON')
            ->where('d3.Cdg_tab', 'ARE');

        // Aplicar filtro de búsqueda
        if (!empty($this->search)) {
            $query->where(function ($subQuery) {
                $subQuery->where('m_vended.Des_vend', 'LIKE', "%{$this->search}%")
                    ->orWhere('M_COTIZACION.Num_cot', 'LIKE', "%{$this->search}%");
            });
        }

        // Obtener resultados paginados
        $cotizaciones = $query->paginate(10);

        return view('livewire.cotizaciones.lista', [
            'cotizaciones' => $cotizaciones,
        ]);
    }
}
