<?php

namespace App\Livewire\Clientes;

use Livewire\Component;
use Illuminate\Support\Facades\DB;
use Illuminate\Pagination\LengthAwarePaginator;

class Lista extends Component
{
    public $search = ''; // Campo de búsqueda
    public $perPage = 10; // Resultados por página

    public function updatingSearch()
    {
        // Reiniciar la paginación al cambiar la búsqueda
        $this->resetPage();
    }

    public function render()
    {
        // Llamada al procedimiento almacenado
        $clientes = DB::connection('sqlsrv')->select('EXEC USP_WEB_SELECT_CLIENTES @search = ?', [
            $this->search ?? ''
        ]);

        // Convertir los resultados en una colección
        $clientesCollection = collect($clientes);

        // Configurar la paginación manual
        $currentPage = LengthAwarePaginator::resolveCurrentPage();
        $currentPageItems = $clientesCollection->slice(($currentPage - 1) * $this->perPage, $this->perPage)->values();
        $clientesPaginated = new LengthAwarePaginator(
            $currentPageItems,
            $clientesCollection->count(),
            $this->perPage,
            $currentPage,
            ['path' => LengthAwarePaginator::resolveCurrentPath()]
        );

        return view('livewire.clientes.lista', [
            'clientes' => $clientesPaginated,
        ]);
    }
}
