<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Pagination\Paginator;
use Carbon\Carbon;
class PedidosController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $search = $request->get('search', ''); // Término de búsqueda
        $tamanio = $request->get('tamanio', 10); // Tamaño de página
        $pagina = $request->get('pagina', 1); // Página actual


        // Llamar al procedimiento almacenado
        $query = "EXEC USP_WEB_SELECT_PEDIDOS";
        $pedidos = DB::connection('sqlsrv')->select($query);

        // Convertir a una colección y filtrar los resultados
        $pedidosCollection = collect($pedidos);

        if (!empty($search)) {
            $pedidosCollection = $pedidosCollection->filter(function ($pedido) use ($search) {
                return str_contains(strtolower($pedido->Num_ped), strtolower($search)) ||
                       str_contains(strtolower($pedido->Ruc_cli), strtolower($search)) ||
                       str_contains(strtolower($pedido->Des_vend), strtolower($search)) ||
                       str_contains(strtolower($pedido->Des_cli), strtolower($search));
            });
        }
        $pedidosCollection = $pedidosCollection->sortBy('Num_ped');
        // Paginación manual
        $pedidosPaginados = new Paginator(
            $pedidosCollection->forPage($pagina, $tamanio),
            $tamanio,
            $pagina
        );

        // Preparar datos para la vista
        $data = [
            'pedidos' => $pedidosPaginados,
            'total' => $pedidosCollection->count(),
            'pagina' => $pagina,
            'tamanio' => $tamanio,
            'total_paginas' => ceil($pedidosCollection->count() / $tamanio),
            'search' => $search,
        ];

        return view('admin.pedidos.index', compact('data'));
    }

    public function create()
    {
        // Obtener el último número de cotización
        $ultimoPedido = DB::connection('sqlsrv')->select("EXEC SP_Cons_T_Correl
        @cNomtab='M_PEDIDO',
        @cCdgcor='PED',
        @cCodloc='001',
        @cDgsuc='901',
        @cCodemp='00001000'");
        
        $NPedido = $ultimoPedido[0]->cor_loc;
        /*convertimos entero */
        $numero=(int)$NPedido;
        //sumamos 1 al valor decimal
        $numero_pedido =$numero +1;
        $binarioResultante=str_pad($numero_pedido,8,'0',STR_PAD_LEFT);
        
        // Datos principales
        $vendedores = DB::connection('sqlsrv')->table('m_vended')->select('Cdg_vend', 'Des_vend')->get();
        $productos = DB::connection('sqlsrv')->select('EXEC USP_WEB_SELECT_PRODUCTOS');
        $clientes = DB::connection('sqlsrv')->select('EXEC USP_WEB_SELECT_CLIENTES');

        // Datos específicos para el modal
        $almacenes = DB::connection('sqlsrv')->table('d_tablas')
            ->where('Cdg_tab', 'ARE') // Relacionado con los almacenes
            ->select('Num_item', 'Des_item')
            ->get();

        $formasPago = [
            '01' => 'Contado',
            '02' => 'Crédito',
        ];
        $lista_precios = DB::connection('sqlsrv')->table('d_tablas')
        ->where('Cdg_tab', 'PRC') // Relacionado con la lista de precios
        ->select('Num_item', 'Des_item')
        ->get();


        $consulta="SELECT des_item, num_item, val_item FROM d_tablas " .
        "WHERE cdg_tab='FPA' AND CAM_ITEM = 'X' and cdg_suc='901' " . 
        "AND swt_item = 1 ORDER BY des_item";
        $condicionesPago = DB::connection('sqlsrv')->select($consulta);

        $monedas = DB::connection('sqlsrv')->table('d_tablas')
            ->where('Cdg_tab', 'MON') // Tabla de monedas
            ->select('Num_item', 'Des_item')
            ->get();

            $tipo_cambios = DB::connection('sqlsrv')
            ->table('t_cambio')
            ->select('Tip_cmb', 'Fec_cmb') // Seleccionar solo las columnas necesarias
            ->orderBy('Fec_cmb', 'desc')   // Ordenar por fecha descendente
            ->get();

        // Obtener el penúltimo registro por fecha
        
        $afectaciones=DB::connection('sqlsrv')->select('USP_WEB_SELECT_AFECTACION');

        $fechhoy=Carbon::now()->format('Ymd');
        
        $tipo_cambios = DB::connection('sqlsrv')->select("select Tip_cmp from t_cambio where fec_cmb ='$fechhoy'");
        
        if(!empty($tipo_cambios)){
            $valor=$tipo_cambios[0]->Tip_cmp;
        }else{
            $valor='';
        }
        return view('admin.pedidos.create', compact(
            'binarioResultante',
            'vendedores',
            'clientes',
            'productos',
            'almacenes',
            'tipo_cambios',
            
            'formasPago',
            'condicionesPago',
            'afectaciones',
            'monedas',
            'lista_precios',
            'valor',

        ));


    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
       
        $Num_ped =isset($request->nuevopedido)?$request->nuevopedido:''; 
        $Cdg_vend =isset($request->vendedor)?$request->vendedor:''; 
        $Cdg_cpag =isset($request->Cdg_cpag)?$request->Cdg_cpag:''; 
        $Cdg_mon =isset($request->Cdg_mon)?$request->Cdg_mon:''; 
        $Fec_ped =isset($request->fechpedido)?Carbon::parse($request->fechpedido)->startOfDay()->format('Ymd'):Carbon::now()->format('Ymd'); 
        $Num_ocom =''; 
        $Imp_stot =isset($request->subtotal)?$request->subtotal:''; 
        $Imp_tigv =isset($request->igv)?$request->igv:''; 
        $Imp_tdct =isset($request->total_descuento)?$request->total_descuento:''; 
        $Imp_ttot =isset($request->total)?$request->total:''; 
        $Por_tdct =isset($request->descuento)?$request->descuento:''; 
        $Por_tigv =0.18; 
        $Obs_ped =isset($request->Obs_ped)?$request->Obs_ped:''; 
        $Swt_ped =''; 
        $Ruc_cli =isset($request->ruc_dni)?$request->ruc_dni:''; 
        $Swt_cot =''; 
        $Fec_anul =''; 
        $Swt_ptv ='P'; 
        $Ori_area ='001'; 
        $Cdg_area ='000'; 
        $Num_cot =''; 
        $Cdg_usr ='SUPERVISOR'; 
        $Cdg_prom ='000'; 
        $Cdg_dist =''; 
        $Ing_usr =Carbon::now()->format('Ymd'); 
        $Cdg_tpg =''; 
        $Swt_prom ='0'; 
        $CDG_SUC ='901'; 
        $CDG_CENT ='00001000'; 
        $m_centro ='00001000'; 
        $FEC_COT =NULL; 
        $FEC_ENT =isset($request->fec_ent)?Carbon::parse($request->fec_ent)->startOfDay()->format('Ymd'):Carbon::now()->format('Ymd'); 
        $FEC_VENC =isset($request->tip_val)?Carbon::parse($request->tip_val)->startOfDay()->format('Ymd'):Carbon::now()->format('Ymd'); 
        $DOC_OCOM =''; 
        $TOT_PESO =''; 
        $DESTINO =isset($request->lug_ent)?Carbon::parse($request->lug_ent)->startOfDay()->format('Ymd'):Carbon::now()->format('Ymd'); 
        $CDG_ETRN =''; 
        $CDG_ETRN1 =''; 
        $CDG_ETRN2 =''; 
        $SWT_PLANI =''; 
        $swt_exportacion =''; 
        $COD_CLASP =''; 
        $IDSUCUR =''; 
        $IDPC =''; 
        $APR_PED =''; 
        $COD_SEDE =''; 
        $FEC_PROC =''; 
        $HOR_PROC =''; 
        $OBS_PROC =isset($request->Obs_ped)?$request->Obs_ped:''; 
        
        $FOR_PAG =isset($request->forpag)?$request->forpag:''; 
        
        $IMP_INAF =isset($request->inafecta)?$request->inafecta:''; 
        $TOT_EXON =isset($request->exonerada)?$request->exonerada:''; 
        $TOT_DSCTO =isset($request->total_descuento)?$request->total_descuento:''; 
        $cdg_incoterm ='';
        
        
        DB::connection('sqlsrv')->statement("EXEC USP_WEB_INSERT_PEDIDO 
        @Num_ped ='$Num_ped', 
        @Cdg_vend ='$Cdg_vend', 
        @Cdg_cpag ='$Cdg_cpag', 
        @Cdg_mon ='$Cdg_mon', 
        @Fec_ped ='$Fec_ped', 
        @Num_ocom ='$Num_ocom', 
        @Imp_stot ='$Imp_stot', 
        @Imp_tigv ='$Imp_tigv', 
        @Imp_tdct ='$Imp_tdct', 
        @Imp_ttot ='$Imp_ttot', 
        @Por_tdct ='$Por_tdct', 
        @Por_tigv ='$Por_tigv', 
        @Obs_ped ='$Obs_ped', 
        @Swt_ped ='$Swt_ped', 
        @Ruc_cli ='$Ruc_cli', 
        @Swt_cot ='$Swt_cot', 
        @Fec_anul ='$Fec_anul', 
        @Swt_ptv ='$Swt_ptv', 
        @Ori_area ='$Ori_area', 
        @Cdg_area ='$Cdg_area', 
        @Num_cot ='$Num_cot', 
        @Cdg_usr ='$Cdg_usr', 
        @Cdg_prom ='$Cdg_prom', 
        @Cdg_dist ='$Cdg_dist', 
        @Ing_usr ='$Ing_usr', 
        @Cdg_tpg ='$Cdg_tpg', 
        @Swt_prom ='$Swt_prom', 
        @CDG_SUC ='$CDG_SUC', 
        @CDG_CENT ='$CDG_CENT', 
        @m_centro ='$m_centro', 
        @FEC_COT ='$FEC_COT', 
        @FEC_ENT ='$FEC_ENT', 
        @FEC_VENC ='$FEC_VENC', 
        @DOC_OCOM ='$DOC_OCOM', 
        @TOT_PESO ='$TOT_PESO', 
        @DESTINO ='$DESTINO', 
        @CDG_ETRN ='$CDG_ETRN', 
        @CDG_ETRN1 ='$CDG_ETRN1', 
        @CDG_ETRN2 ='$CDG_ETRN2', 
        @SWT_PLANI ='$SWT_PLANI', 
        @swt_exportacion ='$swt_exportacion', 
        @COD_CLASP ='$COD_CLASP', 
        @IDSUCUR ='$IDSUCUR', 
        @IDPC ='$IDPC', 
        @APR_PED ='$APR_PED', 
        @COD_SEDE ='$COD_SEDE', 
        @FEC_PROC ='$FEC_PROC', 
        @HOR_PROC ='$HOR_PROC', 
        @OBS_PROC ='$OBS_PROC', 
        @FOR_PAG ='$FOR_PAG', 
        @IMP_INAF ='$IMP_INAF', 
        @TOT_EXON ='$TOT_EXON', 
        @TOT_DSCTO ='$TOT_DSCTO', 
        @cdg_incoterm ='$cdg_incoterm'
                ");


        //aqui debe ir otra insercion de detallepedido
        //debe ir un
        $count=count($request->producto);
        for($i=0 ; $i<$count; ++$i){
            $secuecial=$request->idS[$i];
            $stock=$request->stock[$i];
            $val=$request->preciouni[$i];
            $subtotal=$request->subTotalP[$i];
            $producto=$request->producto[$i];
            $pordec=$request->desc[$i];
            $bonific=($request->bonificacion[$i]=='NO')?'1':'2';
            $afectacion=$request->{'afectacion' .($i+1)};
            $aval=$request->aval[$i];
            if($aval=='G'){
                $val_igv=($stock*0.18);
                $imp_igv=($subtotal*1.18);
            }else{
                $val_igv=0;
                $imp_igv=0;
            }
            $pre_igv=($val*1.18);
            DB::connection('sqlsrv')->statement("EXEC USP_WEB_INSERT_PEDIDO_DET 
            @Num_ped ='$Num_ped' ,
            @Cdg_prod ='$producto' ,
            @Cdg_fprd ='000' ,
            @Can_pprd ='$stock' ,
            @Pre_pprd ='$val' ,
            @Dct_pprd ='$pordec' ,
            @Dct_fic =0.00 ,
            @Igv_pprd =0.00 ,
            @Imp_tprd ='$subtotal' ,
            @Can_dprd =0.00 ,
            @Can_fprd =0.00 ,
            @Obs_pprd ='' ,
            @Cdg_lprc ='000' ,
            @Pre_igv ='$pre_igv' ,
            @Imp_igv ='$imp_igv' ,
            @Swt_kit ='' ,
            @Num_lote ='' ,
            @Can_slot ='$stock' ,
            @Lote =1,
            @CDG_KP ='' ,
            @CAN_KP =0.00,
            @CDG_SUC ='901',
            @CDG_CENT ='00001000',
            @cdg_umed ='001',
            @cdg_eqv ='001',
            @fac_eqv =1.0000,
            @SWT_PERC =0,
            @POR_PERC =0.00,
            @IMP_PERC =0.00,
            @CANTIDAD =0,
            @NUM_SEC ='$secuecial' ,
            @PESO_PROD =0,
            @CDG_FORM ='',
            @COD_AFEC ='$afectacion' ,
            @APL_INP ='$aval' ,
            @VAL_IGV ='$val_igv',
            @COD_BONI ='$bonific'
            ");
        }
        $actulizar=DB::connection('sqlsrv')->statement("UPDATE T_CORREL SET COR_LOC = '$Num_ped'  WHERE NOM_TABLA = 'M_PEDIDO' AND CDG_COR = 'PED' AND CDG_LOC = '001' AND CDG_SUC = '901' AND CDG_CENT = '00001000'");
        return redirect()->route('admin.pedidos.create')->with('success', 'Cotización registrada correctamente.');
    
}


    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
} 