<?php

namespace App\Http\Controllers\admin;
use App\Models\Pais;
use App\Http\Controllers\Controller;
use App\Models\Departamento;
use App\Models\Distrito;
use App\Models\Provincia;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use function Laravel\Prompts\select;
use Carbon\Carbon;

class DistribuidoresController extends Controller
{
    public function index(Request $request)
    {
        $user = Auth::user();
        $cod_patro = $user->cod_distrib;
        

        $search = $request->get('search', ''); // Término de búsqueda
        $tamanio = $request->get('tamanio', 10); // Tamaño de página
        $pagina = $request->get('pagina', 1); // Página actual

        // Obtener distribuidores desde el ERP @cdg_pat='$cod_patro'
        if(!empty($cod_patro) && $cod_patro!=NULL){
            $query = "EXEC USP_WEB_SELECT_DISTRIBUIDORES @cdg_pat='$cod_patro'";

             /*Estado distribuidor*/
             $quer1="SELECT swt_dist FROM distribuidor WHERE cdg_dist='$cod_patro'";
             $estadoDistrib=DB::connection('sqlsrv')->select($quer1);
             $estado=$estadoDistrib[0]->swt_dist;
             /*fin estado distribuidor */

        }else{
            $query="EXEC USP_WEB_LISTA_DISTRIBUIDORES";
            $estado=1;
        }
        
        $distribuidores = DB::connection('sqlsrv')->select($query);

        // Mapear los estados desde la tabla `users`
        $distribuidores = collect($distribuidores)->map(function ($distribuidor) {
            $estadoWeb = DB::table('users')
                ->where('cod_distrib', $distribuidor->cdg_dist)
                ->value('estado'); // Obtener el estado de la tabla users

            $distribuidor->estado_web = $estadoWeb ?? '0'; // Por defecto inactivo si no existe
            return $distribuidor;
        });

        // Filtros de búsqueda
        if (!empty($search)) {
            $distribuidores = $distribuidores->filter(function ($distribuidor) use ($search) {
                return str_contains(strtolower($distribuidor->cdg_dist), strtolower($search)) ||
                    str_contains(strtolower($distribuidor->NOM_DIS), strtolower($search));
            });
        }

        // Paginación manual
        $distribuidoresPaginados = new Paginator(
            $distribuidores->forPage($pagina, $tamanio),
            $tamanio,
            $pagina
        );

        // Preparar datos para la vista
        $data = [
            'distribuidores' => $distribuidoresPaginados,
            'total' => $distribuidores->count(),
            'pagina' => $pagina,
            'tamanio' => $tamanio,
            'total_paginas' => ceil($distribuidores->count() / $tamanio),
            'search' => $search,
        ];

        return view('admin.distribuidores.index', compact('data','cod_patro','estado'));
    } 

    public function create()
    {
        $user = Auth::user();
        $cod_dist = $user->cod_distrib;
        $cod_patro = $user->cod_patroc;
        $estado_web = $user->estado;

        $patrocinadores = DB::connection('sqlsrv')->select("select RTRIM(app_dist) + ' ' + RTRIM(apm_dist) + ', ' + RTRIM(nom_dist) as Nombre, cdg_dist from distribuidor  WHERE cdg_dist='$cod_dist'");
        $distribuidores = DB::connection('sqlsrv')->select("select RTRIM(app_dist) + ' ' + RTRIM(apm_dist) + ', ' + RTRIM(nom_dist) as Nombre, cdg_dist from distribuidor  WHERE cdg_pat ='$cod_dist'");

        $paises = DB::connection('sqlsrv')->select("SELECT des_pais, cdg_pais from m_pais order by des_pais");

        $documentos = DB::connection('sqlsrv')->select("SELECT cdg_docum,descripcion from t_perso where cdg_docum <> '11' order by descripcion");

        $relacion = collect($distribuidores)->pluck('Nombre', 'cdg_dist');
        $vendedores = DB::connection('sqlsrv')->table('m_vended')->select('Cdg_vend', 'Des_vend')->get();
        return view('admin.distribuidores.create', compact(
            'paises',
            'patrocinadores',
            'distribuidores',
            'documentos',
            'vendedores',
            'relacion',
            
        ));
    } 


    public function store(Request $request){
        
        $user =Auth::user();
        $cod_usuario=$user->email;
        /*obteniendo codigo libre */
        $prepara_cod=DB::connection('sqlsrv')->select("EXEC [dbo].[UPS_WEB_GET_COD_SEP]");
        $cod_disp=$prepara_cod[0]->cdg_numdispon;
        $dni=isset($request->dni)?$request->dni:'';
        $nombre=isset($request->nombre)?$request->nombre:'';
        $paterno=isset($request->paterno)?$request->paterno:'';
        $materno=isset($request->materno)?$request->materno:'';
        $nacimiento =isset($request->nacimiento)?Carbon::parse($request->nacimiento)->startOfDay()->format('Ymd'): Carbon::now()->format('Ymd');
        $estadoC=isset($request->estadoC)?$request->estadoC:'';
        $sexo=isset($request->sexo)?$request->sexo:'';
        $distribuidor=isset($request->distribuidor)?$request->distribuidor:'';

        $patrocinador=isset($request->patrocinador)?$request->patrocinador:'';
        $DistriP=isset($request->DistriP)?$request->DistriP:'';
        $asignar=$request->asignar;
        if($asignar =='option1'){
            $patroasig=$patrocinador;
        }else{
            $patroasig=$DistriP;
        }
        
        $telefono=isset($request->telefono)?$request->telefono:'';
        $email=isset($request->email)?$request->email:'';
        $pais=isset($request->pais)?$request->pais:'';
        $departamento=isset($request->departamento)?$request->departamento:'';
        $provincia=isset($request->provincia)?$request->provincia:'';
        $distrito=isset($request->distrito)?$request->distrito:'';
        $direccion=isset($request->direccion)?$request->direccion:'';
        $document=isset($request->document)?$request->document:'';
        $condicion=isset($request->condicion)?$request->condicion:'';
        $lisprecio=isset($request->lisprecio)?$request->lisprecio:'';
        $vendedor=isset($request->vendedor)?$request->vendedor:'001';
        $observacion=isset($request->observacion)?$request->observacion:'';
        $activo=isset($request->activo)?$request->activo:'0';
        $suspendido=isset($request->supendido)?$request->supendido:'';
        $procedencia=isset($request->procedencia)?$request->procedencia:'';
        $ruc=isset($request->ruc)?$request->ruc:'';
        $tipoclien=isset($request->tipoclien)?$request->tipoclie:'';
        $fecA=isset($request->fecA)?Carbon::parse($request->fecA)->startOfDay()->format('Ymd'):Carbon::now()->format('Ymd');
        $numruc=isset($request->numruc)?$request->numruc:'';
        $preparInsDistri=DB::connection('sqlsrv')->statement("EXEC [dbo].[USP_INSERT_DISTRIBUIDOR]
            @modo = 1,
            @Cdg_dist='$cod_disp',
            @App_dist='$paterno',
            @Apm_dist='$materno',
            @Nom_dist='$nombre',
            @Des_dist='$distribuidor',
            @Doc_dist='$dni',
            @Dir_dist='$direccion',
            @Tel_dist='$telefono',
            @fax_dist='',
            @Nac_dist='$nacimiento',
            @Ema_dist='$email',
            @Cdg_bco='NULL',
            @Num_cta='NULL',
            @Tip_cta='NULL',
            @Cdg_pat='$patroasig',
            @Cdg_civ='$estadoC',
            @Cdg_cob='NULL',
            @Num_afil='NULL',
            @Swt_dist='$activo',
            @Dst_fac='NULL',
            @Dir_fac='NULL',
            @Des_fac='NULL',
            @Ruc_dist='$numruc',
            @Swt_ruc=$ruc,
            @Cdg_usr='SUPERVISOR',
            @Fec_usr='$fecA',
            @Fec_afil='$fecA',
            @Sex_dist='$sexo',
            @Cdg_fact='',
            @Swt_fact='1',
            @Nom_tia='Maria pia',
            @Tdc_dist ='$document',
            @Cdg_vend ='$vendedor',
            @cdg_docum ='$document',
            @Obs_dist ='$observacion',
            @xsucur ='901',
            @xcentro ='00001000',
            @xnumsep ='',
            @swt_afil =1,
            @cdg_pais ='$pais',
            @cdg_dsto ='$distrito',
            @codreclu = ''
        ");
        $cambistatu=DB::connection('sqlsrv')->statement("EXEC [dbo].[USP_CAMBIAR_STATU_NUM_SEP] @cdg_numdispon = '$cod_disp'");
        if($activo == '1'){
            $user = User::create([
                'name' => $distribuidor,
                'email' => $cod_disp,
                'password' => Hash::make($cod_disp), // Asegúrate de encriptar la contraseña
                'cod_distrib'=>$cod_disp,
                'estado'=>'1', 
            ]);
        }else{
            $user = User::create([
                'name' => $distribuidor,
                'email' => $cod_disp,
                'password' => Hash::make($cod_disp), // Asegúrate de encriptar la contraseña
                'cod_distrib'=>$cod_disp,
                'estado'=>'0', 
            ]);
        }
        
        $user->assignRole('Distribuidor');
        return redirect()->route('admin.distribuidores.index');
        
    }
    public function departamento(Request $request){
        $codigo_pais=$request->codigo_pais;
        $paises = DB::connection('sqlsrv')->select("SELECT des_dpto, cdg_dpto FROM m_dptos WHERE cdg_pais = '$codigo_pais' ORDER BY des_dpto");
        $html='';
        foreach ($paises as $pais) {
            $html.="<option value='{$pais->cdg_dpto}'>{$pais->des_dpto} </option>";

        }
        return response()->json(['html'=>$html]);

    }

    public function provincia(Request $request){
        $codigo_pais=$request->codigo_pais;
        $codigo_departamento=$request->codigo_departamento;
        $provincias = DB::connection('sqlsrv')->select("SELECT des_prov, cdg_prov FROM m_prov WHERE cdg_pais = '$codigo_pais' and LEFT(cdg_prov,2)= '$codigo_departamento' ORDER BY des_prov");

        $html='';
        foreach ($provincias as $provincia) {
            $html.="<option value='{$provincia->cdg_prov}'>{$provincia->des_prov} </option>";

        }
        return response()->json(['html'=>$html]);

    }

    public function distrito(Request $request){
        $codigo_pais=$request->codigo_pais;
        $codigo_provincia=$request->codigo_provincia;
        $distritos = DB::connection('sqlsrv')->select("SELECT des_dsto, cdg_dsto FROM m_dsto WHERE cdg_pais = '$codigo_pais' and LEFT(cdg_dsto,4)= '$codigo_provincia' ORDER BY des_dsto");

        $html='';
        foreach ($distritos as $distrito) {
            $html.="<option value='{$distrito->cdg_dsto}'>{$distrito->des_dsto} </option>";

        }
        return response()->json(['html'=>$html]);

    }
    public function perfil(){
        $documentos = DB::connection('sqlsrv')->select("SELECT cdg_docum,descripcion from t_perso where cdg_docum <> '11' order by descripcion");
        

        $user =Auth::user();
        $idDist=$user->cod_distrib;
        $sql1="EXEC USP_WEB_OBTENER_PATRO @cdg_dist=$idDist";
        $distri = DB::connection('sqlsrv')->select($sql1);
        $patrocinador=$distri[0]->cdg_pat;
        $sql="EXEC USP_WEB_OBTENER_DISTRIBUIDOR
              @cdg_dist=$idDist";
        $distribuidores = DB::connection('sqlsrv')->select($sql);

        $distPais=$distribuidores[0]->cdg_pais;
        $distDep=$distribuidores[0]->Depart;
        $distPro=$distribuidores[0]->provin;
        //dd($distPais);
        $paises = DB::connection('sqlsrv')->select("SELECT des_pais, cdg_pais from m_pais order by des_pais");
        $departamentos = DB::connection('sqlsrv')->select("SELECT des_dpto, cdg_dpto,cdg_pais FROM m_dptos WHERE cdg_pais='$distPais'");
        $provincias = DB::connection('sqlsrv')->select("SELECT des_prov, cdg_prov,cdg_pais FROM m_prov WHERE cdg_pais='$distPais' AND cdg_prov LIKE '$distDep%'");
        $distritos = DB::connection('sqlsrv')->select("SELECT des_dsto, cdg_dsto,cdg_pais FROM m_dsto WHERE cdg_pais='$distPais' AND  cdg_dsto LIKE '$distPro%'");
        
        return view('admin.distribuidores.perfil',compact('distribuidores','documentos','paises','departamentos','provincias','distritos'));
    }
    public function activo($cod){
        
       $EstadoDistribuidor=DB::connection('sqlsrv')->select("SELECT swt_dist FROM distribuidor  WHERE cdg_dist='$cod'");
       $estado=$EstadoDistribuidor[0]->swt_dist;
       if($estado){
        DB::connection('sqlsrv')->statement("UPDATE distribuidor SET swt_dist=0 WHERE cdg_dist='$cod'");
        
       }else{
        DB::connection('sqlsrv')->statement("UPDATE distribuidor SET swt_dist=1 WHERE cdg_dist='$cod'");
        
       }
       return redirect()->route('admin.distribuidores.index');
    }
    public function cambiarEstadoWebMasivo(Request $request)
    {
        $cod_distribs = $request->input('cod_distribs', []);
        $estado = $request->input('estado');

        if (empty($cod_distribs)) {
            return response()->json(['message' => 'No se seleccionaron distribuidores.'], 400);
        }

        $rolesDistribuidorId = DB::table('roles')->where('name', 'Distribuidor')->value('id');

        try {
            foreach ($cod_distribs as $cod_distrib) {
                // Obtener nombre completo del distribuidor desde SQL Server
                $result = DB::connection('sqlsrv')->select("SELECT TOP (1) des_dist AS NOM_DIS FROM [BDENJOVI].[dbo].[distribuidor] WHERE cdg_dist = ?", [$cod_distrib]);

                if (empty($result)) {
                    return response()->json(['message' => 'Distribuidor no encontrado.'], 404);
                }

                $nom_distrib = $result[0]->NOM_DIS;

                // Verificar si el usuario ya existe en la tabla 'users'
                $user = User::where('cod_distrib', $cod_distrib)->first();

                if ($user) {
                    // Actualizar el estado si ya existe
                    $user->update(['estado' => $estado]);

                    // Asignar rol "Distribuidor"
                    $user->assignRole('Distribuidor');
                } else {
                    // Crear un nuevo registro si no existe
                    $userId = DB::table('users')->insertGetId([
                        'cod_distrib' => $cod_distrib,
                        'estado' => $estado,
                        'name' => $nom_distrib, // Nombre del distribuidor
                        'email' => $cod_distrib, // Utilizar código como email temporal
                        'password' => bcrypt($cod_distrib),
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);

                    // Asignar rol "Distribuidor"
                    DB::table('model_has_roles')->insert([
                        'role_id' => $rolesDistribuidorId,
                        'model_type' => 'App\Models\User',
                        'model_id' => $userId,
                    ]);

                    $user = User::find($userId);
                    $user->assignRole('Distribuidor');
                }
            }

            return response()->json(['message' => 'Estado cambiado con éxito.']);
        } catch (\Exception $e) {
            return response()->json(['message' => 'Error al cambiar el estado', 'error' => $e->getMessage()], 500);
        }
    } 

    public function update(Request $request ,$codistri){
        $query=DB::connection('sqlsrv')->select("SELECT ruc_cli from distribuidor where cdg_dist='$codistri'");
        $ruc_cli=$query[0]->ruc_cli;
        $nombre=isset($request->nombre)?trim($request->nombre):'';
        $paterno=isset($request->paterno)?trim($request->paterno):'';
        $materno=isset($request->materno)?trim($request->materno):'';
        $tipo_docu=isset($request->tipo_docu)?$request->tipo_docu:'';
        $numdocu=isset($request->numdocu)?$request->numdocu:'';
        $cdgpat=isset($request->cdgpat)?$request->cdgpat:'';
        $sexo=isset($request->sexo)?$request->sexo:'';
        $pais=isset($request->pais)?$request->pais:'';
        $distrito=isset($request->distrito)?$request->distrito:'';
        $direccion=isset($request->direccion)?$request->direccion:'';
        $nacimiento=isset($request->nacimiento)?Carbon::parse($request->nacimiento)->startOfDay()->format('Ymd'):Carbon::now()->format('Ymd');
        $telefono=isset($request->telefono)?$request->telefono:'';
        $email=isset($request->email)?$request->email:'';
        $afil=isset($request->afil)?Carbon::parse($request->afil)->startOfDay()->format('Ymd'):Carbon::now()->format('Ymd');
        
        DB::connection('sqlsrv')->statement("USP_WEB_UPDATE_DISTRIBUIDOR
        @cdg_dist='$codistri',
        @app_dist='$paterno',
        @apm_dist ='$materno',
        @nom_dist='$nombre',
        @tdc_dist='$tipo_docu',
        @doc_dist=$numdocu,
        @cdg_pat ='$cdgpat',
        @cdg_pais='$pais',
        @cdg_dsto='$distrito',
        @sex_dist='$sexo',
        @dir_dist='$direccion',
        @nac_dist='$nacimiento',
        @tel_dist='$telefono',
        @ema_dist='$email',
        @fec_afil= '$afil',
        @cod_cat=1,
        @ruc_cli='$ruc_cli'");


        User::where('cod_distrib',$codistri)->update([
            'name'=>$paterno.' '.$materno.' '.$nombre
        ]);

        return redirect()->route('admin.distribuidores.perfil');
    }
    
}
