<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Contracts\Session\Session;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Pagination\Paginator;
use Carbon\Carbon;
class CotizacionesController extends Controller
{
    public function index(Request $request)
    {
        $search = $request->get('search', ''); // Término de búsqueda
        $tamanio = $request->get('tamanio', 10); // Tamaño de página
        $pagina = $request->get('pagina', 1); // Página actual

        // Llamar al procedimiento almacenado
        $query = "EXEC USP_WEB_SELECT_COTIZACION";
        $cotizaciones = DB::connection('sqlsrv')->select($query);

        // Convertir a una colección y aplicar filtro de búsqueda
        $cotizacionesCollection = collect($cotizaciones);

        if (!empty($search)) {
            $cotizacionesCollection = $cotizacionesCollection->filter(function ($cotizacion) use ($search) {
                return str_contains(strtolower($cotizacion->Num_cot), strtolower($search)) ||
                    str_contains(strtolower($cotizacion->Cdg_vend), strtolower($search)) ||
                    str_contains(strtolower($cotizacion->Des_cli), strtolower($search));
            });
        }

        // Total de elementos después del filtro
        $total = $cotizacionesCollection->count();

        // Paginación manual utilizando Illuminate\Pagination\Paginator
        $items = $cotizacionesCollection->forPage($pagina, $tamanio);
        $paginados = new Paginator($items, $tamanio, $pagina);

        // Datos para la vista
        $data = [
            'items' => $paginados,
            'total' => $total,
            'pagina' => $pagina,
            'tamanio' => $tamanio,
            'total_paginas' => ceil($total / $tamanio),
            'search' => $search,
        ];

        return view('admin.cotizaciones.index', compact('data'));
    }

    public function create()
    {
        // Obtener el último número de cotización
        $ultimoCotizacion = DB::connection('sqlsrv')->select("EXEC SP_Cons_T_Correl
        @cNomtab='M_COTIZACION',
        @cCdgcor='',
        @cCodloc='',
        @cDgsuc='901',
        @cCodemp='00001000'");
        
        $numCotizacion = $ultimoCotizacion[0]->num_correl;
        $cotizacion=(int)$numCotizacion + 1;
        $nuevoCotizacion=(string)$cotizacion;
        // Datos principales
        $vendedores = DB::connection('sqlsrv')->table('m_vended')->select('Cdg_vend', 'Des_vend')->get();
        $productos = DB::connection('sqlsrv')->select('EXEC USP_WEB_SELECT_PRODUCTOS');
        $clientes = DB::connection('sqlsrv')->select('EXEC USP_WEB_SELECT_CLIENTES');
        

        // Datos específicos para el modal
        $almacenes = DB::connection('sqlsrv')->table('d_tablas')
            ->where('Cdg_tab', 'ARE') // Relacionado con los almacenes
            ->select('Num_item', 'Des_item')
            ->get();

        $formasPago = [
            '01' => 'Contado',
            '02' => 'Crédito',
        ];
        $lista_precios = DB::connection('sqlsrv')->table('d_tablas')
            ->where('Cdg_tab', 'PRC') // Relacionado con la lista de precios
            ->select('Num_item', 'Des_item')
            ->get();

        $consulta="SELECT des_item, num_item, val_item FROM d_tablas " .
        "WHERE cdg_tab='FPA' AND CAM_ITEM = 'X' and cdg_suc='901' " . 
        "AND swt_item = 1 ORDER BY des_item";
        $condicionesPago = DB::connection('sqlsrv')->select($consulta);

        $monedas = DB::connection('sqlsrv')->table('d_tablas')
            ->where('Cdg_tab', 'MON') // Tabla de monedas
            ->select('Num_item', 'Des_item')
            ->get();


        //Tipo de cambio
        /*$tipo_cambios = DB::connection('sqlsrv')
        ->table('t_cambio')
        ->select('Fec_cmb', 'Tip_cmb') // Seleccionar solo las columnas necesarias
        ->orderBy('Fec_cmb', 'desc')   // Ordenar por fecha descendente
        ->get();

    // Obtener el penúltimo tipo de cambio (último - 1)
    $penultimo_tipo_cambio = DB::connection('sqlsrv')
        ->table('t_cambio')
        ->select('Tip_cmb') // Seleccionar solo el tipo de cambio
        ->orderBy('Fec_cmb', 'desc')  // Ordenar por fecha descendente
        ->skip(1) // Saltar el primer registro
        ->take(1) // Tomar solo el segundo registro
        ->first();*/

        $fechhoy=Carbon::now()->format('Ymd');
        
        $tipo_cambios = DB::connection('sqlsrv')->select("select Tip_cmp from t_cambio where fec_cmb ='$fechhoy'");
        
        if(!empty($tipo_cambios)){
            $valor=$tipo_cambios[0]->Tip_cmp;
        }else{
            $valor='';
        }
       

        // Obtener el penúltimo registro por fecha
        $penultimo_tipo_cambio = DB::connection('sqlsrv')
            ->table('t_cambio')
            ->select('Tip_cmb', 'Fec_cmb')
            ->orderBy('Fec_cmb', 'desc') // Ordenar por fecha descendente
            ->skip(1)                    // Saltar el último (más reciente)
            ->take(1)                    // Tomar el segundo (penúltimo)
            ->first();
        $afectaciones=DB::connection('sqlsrv')->select('USP_WEB_SELECT_AFECTACION');
        $listadopedido = session('listadopedido', []);    
        return view('admin.cotizaciones.create', compact(
            'nuevoCotizacion',
            'vendedores',
            'clientes',
            'productos',
            'almacenes',
            'valor',
            'penultimo_tipo_cambio',
            'formasPago',
            'condicionesPago',
            'monedas',
            'lista_precios',
            'listadopedido',
            'afectaciones'
        ));
    }


    public function store(Request $request)
    {
        
            /*calculo*/ 
            $suttotal=isset($request->subtotal)?$request->subtotal:0.00;
            $porcdesc=isset($request->descuento)?$request->descuento:0;
            $inafe=isset($request->inafecta)?$request->inafecta:0.00;
            $exone=isset($request->exonerada)?$request->exonerada:0.00;
            $igv=isset($request->igv)?$request->igv:0.00;
            $totdesc=isset($request->total_descuento)?$request->total_descuento:0.00;
            $total=isset($request->total)?$request->total:0.00;
            $Por_tigv=18.00;

            /*calculo*/
            $swtcot='';
            $cdg_area='001';
            $swt_prom='0';
            $cdg_prom='000';
            $coduser='SUPERVISOR';
            $ingusu = Carbon::now()->format('Ymd');
            $swt_des_compu='0';
            $cdg_incotem='';
            $swt_exp='0';
            $cdgp='002';

            $numcot=isset($request->Num_cot)?$request->Num_cot:'';
            $fechcot = Carbon::parse($request->fec_cot)->startOfDay()->format('Ymd');
            $cdg_cli=isset($request->dni)?$request->dni:'';
            $vendedor=isset($request->Cdg_vend)?$request->Cdg_vend:'001';
            $formpago=isset($request->FOR_PAG)?$request->FOR_PAG:'';
            $cdgcon=isset($request->Cdg_cpag) ?$request->Cdg_cpag: '';
            $cdgmon=isset($request->Cdg_mon)?$request->Cdg_mon:'';
            $listpre=isset($request->Cdg_lpre)?$request->Cdg_lpre:'';
            $codunidad=isset($request->unimedi) ?$request->unimedi:'';
            $tipocam=isset($request->tip_cmb)?$request->tip_cmb:1.0;
            
            
            $referencia=isset($request->Num_oCom)?$request->Num_oCom:'';
            $lug_ent=isset($request->lug_ent)?$request->lug_ent:'';
            $fec_vali=isset($request->fech_vali)?Carbon::parse($request->fech_vali)->startOfDay()->format('Ymd'):'NULL';
            $fechent =isset($request->fec_ent)?Carbon::parse($request->fec_ent)->startOfDay()->format('Ymd'):'NULL';
            $tipova=$request->tip_garantia;
            $garantia=isset($request->garantia)?$request->garantia:'';
            $observa=isset($request->Obs_ped)?$request->Obs_ped:'';
            $fecha_anulado='NULL';
        

    DB::connection('sqlsrv')->statement("EXEC USP_WEB_INSERT_COTIZACIONES_CAB
    @Num_cot = '$numcot',
    @Fec_cot = '$fechcot',
    @Ruc_cli = '$cdg_cli',
    @cdg_unidad = '$codunidad',
    @cdg_con = '',
    @Cdg_vend = '$vendedor',
    @Cdg_cpag = '$cdgcon',
    @Cdg_mon = '$cdgmon',
    @Cdg_lpre = '$listpre',
    @Num_oCom =  '$referencia',
    @fec_ocom = '$fec_vali',
    @tip_cmb = $tipocam,
    @tip_val = $tipova,
    @fec_ent = '$fechent',
    @lug_ent = '$lug_ent',
    @garantia = '$garantia',

    @Imp_inaf = $inafe,
    @Imp_stot = $suttotal,
    @Imp_tigv = $igv,
    @Imp_tdct = $totdesc,
    @Imp_ttot = $total,
    @Por_tdct = $porcdesc,
    @Por_tigv = $Por_tigv,

    @Obs_ped = '$observa',
    @Swt_cot = '$swtcot',
    @Fec_anul =$fecha_anulado,
    @Cdg_area = '$cdg_area',
    @Cdg_prom = '$cdg_prom',
    @Cdg_tpg = '02',
    @Swt_prom = '$swt_prom',
    @Cdg_usr = '$coduser',
    @Ing_usr = '$ingusu',
    @OBS_COTI = '$observa',
    @swt_descompauto = '$swt_des_compu',
    @FOR_PAG = '$formpago',
    @TOT_EXON = $exone,
    @TOT_DSCTO = $totdesc,
    @cdg_incoterm = '$cdg_incotem',
    @swt_exportacion = '$swt_exp'"
    );

        
        // Insertar los detalles de la cotización
        $count=count($request->producto);
        for($i=0 ; $i<$count; ++$i)
          {
            $stock=$request->stock[$i];
            $val=$request->preciouni[$i];
            $subtotal=$request->subTotalP[$i];
            $producto=$request->producto[$i];
            $pordec=$request->desc[$i];
            $bonific=($request->bonificacion[$i]=='NO')?'1':'2';
            $afectacion=$request->{'afectacion' .($i+1)};
            $aval=$request->aval[$i];
            if($aval=='G'){
                $val_igv=($stock*0.18);
                $imp_igv=($subtotal*1.18);
            }else{
                $val_igv=0;
                $imp_igv=0;
            }
            $pre_igv=($val*1.18);
            $id=$request->id[$i];
            DB::connection('sqlsrv')->statement("EXEC USP_WEB_INSERT_COTIZACIONES_DET
            @Num_cot ='$numcot' ,
            @Cdg_prod ='$producto',
            @igv_prod =1 ,
            @Cdg_fprd ='000' ,
            @Can_pprd ='$stock',
            @Pre_pprd ='$val' ,
            @Dct_pprd ='$pordec' ,
            @Dct_fic =0.00 ,
            @Igv_pprd =0.000 ,
            @Imp_tprd ='$subtotal',
            @Can_dprd =0.00 ,
            @Can_fprd =0.00 ,
            @Obs_pprd ='$observa' ,
            @Cdg_lprc ='000' ,
            @Pre_igv ='$pre_igv',
            @Imp_igv ='$imp_igv',
            @Swt_kit ='' ,
            @Num_lote ='' ,
            @Can_slot ='$stock',
            @Lote =1,
            @cdg_kp ='000001' ,
            @can_kp =0.00 ,
            @cdg_umed ='001' ,
            @cdg_eqv ='001' ,
            @fac_eqv =1.00 ,
            @swt_perc =1 ,
            @por_perc =0.00 ,
            @imp_perc =0.00 ,
            @cantidad =0 ,
            @num_sec =$id,
            @CDG_FORM ='' ,
            @COD_AFEC ='$afectacion',
            @APL_INP='$aval',
            @VAL_IGV ='$val_igv' ,
            @COD_BONI ='$bonific'  "
            );
        }
        $actulizar=DB::connection('sqlsrv')->statement("UPDATE T_CORREL SET num_correl = '$numcot'  WHERE NOM_TABLA = 'M_COTIZACION' AND CDG_COR = '' AND CDG_LOC = '' AND CDG_SUC = '901' AND CDG_CENT = '00001000'");
        return redirect()->route('admin.cotizaciones.index')->with('success', 'Cotización registrada con éxito.');
    }

}
