<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use GuzzleHttp\Client;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Pagination\Paginator;
class ClientesController extends Controller
{
    public function index(Request $request)
{
    $search = $request->get('search', ''); // Término de búsqueda
    $tamanio = $request->get('tamanio', 10); // Tamaño de página
    $pagina = $request->get('pagina', 1); // Página actual

    // Llamar al procedimiento almacenado
    $query = "EXEC USP_WEB_SELECT_CLIENTES";
    $clientes = DB::connection('sqlsrv')->select($query);

    // Convertir a una colección y filtrar los resultados
    $clientesCollection = collect($clientes);

    if (!empty($search)) {
        $clientesCollection = $clientesCollection->filter(function ($cliente) use ($search) {
            return str_contains(strtolower($cliente->Ruc_cli), strtolower($search)) ||
                   str_contains(strtolower($cliente->Des_cli), strtolower($search));
        });
    }

    // Paginación manual
    $clientesPaginados = new Paginator(
        $clientesCollection->forPage($pagina, $tamanio),
        $tamanio,
        $pagina
    );

    // Si no es Ajax, devolver la vista principal
    $data = [
        'clientes' => $clientesPaginados,
        'total' => $clientesCollection->count(),
        'pagina' => $pagina,
        'tamanio' => $tamanio,
        'total_paginas' => ceil($clientesCollection->count() / $tamanio),
        'search' => $search,
    ];

    return view('admin.clientes.index', compact('data'));
}


    public function create()
    {
        $paises = DB::connection('sqlsrv')->select("SELECT des_pais, cdg_pais from m_pais order by des_pais");
        return view('admin.clientes.create',compact('paises'));
    }

    public function getcliente(Request $request){
        $idcliente=$request->idcliente;
        $cliente=DB::connection('sqlsrv')->select("EXEC SELECCIONAR_CLIENTE @ruc_cli='$idcliente'");

        $ruc=$cliente[0]->Ruc_cli;
        $descripcion=$cliente[0]->Des_cli;
        $direccion=$cliente[0]->Dir_cli;
        $email=$cliente[0]->Ema_cli;

        
        return response()->json(
            [
                'mensaje'=>1,
                'ruc'=>trim($ruc),
                'Descrip'=>trim($descripcion),
                'direccion'=>trim($direccion),
                'email'=>trim($email),
            ]
            );
        
    }

}

