<?php

namespace App\Exceptions;

use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Throwable;

class Handler extends ExceptionHandler
{
    /**
     * The list of the inputs that are never flashed to the session on validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     */
    public function register(): void
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }

    /**
     * Handle custom rendering for specific exceptions.
     */
    public function render($request, Throwable $exception)
    {
        // Manejar excepciones de autorización
        if ($exception instanceof AuthorizationException) {
            // Redirigir al usuario a una página específica con un mensaje
            return redirect()->route('dashboard')->with('error', 'No tienes permiso para acceder a esta página.');
        }

        return parent::render($request, $exception);
    }
}
