<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class GeneratePermissions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:generate-permissions';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
{
    $menu = config('adminlte.menu');
    $permissions = app(RoleController::class)->extractPermissions($menu);

    foreach ($permissions as $permission) {
        Permission::firstOrCreate(['name' => $permission], ['guard_name' => 'web']);
    }

    $this->info('Permisos generados con éxito.');
}

}
